/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.domains;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class CreateDomainRequest
implements Validatable {
    private final String name;
    private final String owningOrganizationId;
    private final Boolean wildcard;

    CreateDomainRequest(String name, String owningOrganizationId, Boolean wildcard) {
        this.name = name;
        this.owningOrganizationId = owningOrganizationId;
        this.wildcard = wildcard;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.name == null) {
            builder.message("name must be specified");
        }
        if (this.wildcard == null) {
            builder.message("wildcard must be specified");
        }
        return builder.build();
    }

    public static CreateDomainRequestBuilder builder() {
        return new CreateDomainRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateDomainRequest)) {
            return false;
        }
        CreateDomainRequest other = (CreateDomainRequest)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$owningOrganizationId = this.getOwningOrganizationId();
        String other$owningOrganizationId = other.getOwningOrganizationId();
        if (this$owningOrganizationId == null ? other$owningOrganizationId != null : !this$owningOrganizationId.equals(other$owningOrganizationId)) {
            return false;
        }
        Boolean this$wildcard = this.getWildcard();
        Boolean other$wildcard = other.getWildcard();
        return !(this$wildcard == null ? other$wildcard != null : !((Object)this$wildcard).equals(other$wildcard));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $owningOrganizationId = this.getOwningOrganizationId();
        result = result * 59 + ($owningOrganizationId == null ? 43 : $owningOrganizationId.hashCode());
        Boolean $wildcard = this.getWildcard();
        result = result * 59 + ($wildcard == null ? 43 : ((Object)$wildcard).hashCode());
        return result;
    }

    public String toString() {
        return "CreateDomainRequest(name=" + this.getName() + ", owningOrganizationId=" + this.getOwningOrganizationId() + ", wildcard=" + this.getWildcard() + ")";
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="owning_organization_guid")
    public String getOwningOrganizationId() {
        return this.owningOrganizationId;
    }

    @JsonProperty(value="wildcard")
    public Boolean getWildcard() {
        return this.wildcard;
    }

    public static class CreateDomainRequestBuilder {
        private String name;
        private String owningOrganizationId;
        private Boolean wildcard;

        CreateDomainRequestBuilder() {
        }

        public CreateDomainRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CreateDomainRequestBuilder owningOrganizationId(String owningOrganizationId) {
            this.owningOrganizationId = owningOrganizationId;
            return this;
        }

        public CreateDomainRequestBuilder wildcard(Boolean wildcard) {
            this.wildcard = wildcard;
            return this;
        }

        public CreateDomainRequest build() {
            return new CreateDomainRequest(this.name, this.owningOrganizationId, this.wildcard);
        }

        public String toString() {
            return "CreateDomainRequest.CreateDomainRequestBuilder(name=" + this.name + ", owningOrganizationId=" + this.owningOrganizationId + ", wildcard=" + this.wildcard + ")";
        }
    }
}

