/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.domains;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class DeleteDomainRequest
implements Validatable {
    private final Boolean async;
    private final String domainId;

    DeleteDomainRequest(Boolean async, String domainId) {
        this.async = async;
        this.domainId = domainId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.domainId == null) {
            builder.message("domain id must be specified");
        }
        return builder.build();
    }

    public static DeleteDomainRequestBuilder builder() {
        return new DeleteDomainRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteDomainRequest)) {
            return false;
        }
        DeleteDomainRequest other = (DeleteDomainRequest)o;
        Boolean this$async = this.getAsync();
        Boolean other$async = other.getAsync();
        if (this$async == null ? other$async != null : !((Object)this$async).equals(other$async)) {
            return false;
        }
        String this$domainId = this.getDomainId();
        String other$domainId = other.getDomainId();
        return !(this$domainId == null ? other$domainId != null : !this$domainId.equals(other$domainId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $async = this.getAsync();
        result = result * 59 + ($async == null ? 43 : ((Object)$async).hashCode());
        String $domainId = this.getDomainId();
        result = result * 59 + ($domainId == null ? 43 : $domainId.hashCode());
        return result;
    }

    public String toString() {
        return "DeleteDomainRequest(async=" + this.getAsync() + ", domainId=" + this.getDomainId() + ")";
    }

    @QueryParameter(value="async")
    public Boolean getAsync() {
        return this.async;
    }

    @JsonIgnore
    public String getDomainId() {
        return this.domainId;
    }

    public static class DeleteDomainRequestBuilder {
        private Boolean async;
        private String domainId;

        DeleteDomainRequestBuilder() {
        }

        public DeleteDomainRequestBuilder async(Boolean async) {
            this.async = async;
            return this;
        }

        public DeleteDomainRequestBuilder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public DeleteDomainRequest build() {
            return new DeleteDomainRequest(this.async, this.domainId);
        }

        public String toString() {
            return "DeleteDomainRequest.DeleteDomainRequestBuilder(async=" + this.async + ", domainId=" + this.domainId + ")";
        }
    }
}

