/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.domains;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Domain {
    private final String id;
    private final String name;
    private final String owningOrganizationId;
    private final String routerGroupId;
    private final List<String> routerGroupTypes;

    Domain(@JsonProperty(value="guid") String id, @JsonProperty(value="name") String name, @JsonProperty(value="owning_organization_guid") String owningOrganizationId, @JsonProperty(value="router_group_guid") String routerGroupId, @JsonProperty(value="router_group_types") List<String> routerGroupTypes) {
        this.id = id;
        this.name = name;
        this.owningOrganizationId = owningOrganizationId;
        this.routerGroupId = routerGroupId;
        this.routerGroupTypes = routerGroupTypes;
    }

    public static DomainBuilder builder() {
        return new DomainBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getOwningOrganizationId() {
        return this.owningOrganizationId;
    }

    public String getRouterGroupId() {
        return this.routerGroupId;
    }

    public List<String> getRouterGroupTypes() {
        return this.routerGroupTypes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Domain)) {
            return false;
        }
        Domain other = (Domain)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$owningOrganizationId = this.getOwningOrganizationId();
        String other$owningOrganizationId = other.getOwningOrganizationId();
        if (this$owningOrganizationId == null ? other$owningOrganizationId != null : !this$owningOrganizationId.equals(other$owningOrganizationId)) {
            return false;
        }
        String this$routerGroupId = this.getRouterGroupId();
        String other$routerGroupId = other.getRouterGroupId();
        if (this$routerGroupId == null ? other$routerGroupId != null : !this$routerGroupId.equals(other$routerGroupId)) {
            return false;
        }
        List<String> this$routerGroupTypes = this.getRouterGroupTypes();
        List<String> other$routerGroupTypes = other.getRouterGroupTypes();
        return !(this$routerGroupTypes == null ? other$routerGroupTypes != null : !((Object)this$routerGroupTypes).equals(other$routerGroupTypes));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $owningOrganizationId = this.getOwningOrganizationId();
        result = result * 59 + ($owningOrganizationId == null ? 43 : $owningOrganizationId.hashCode());
        String $routerGroupId = this.getRouterGroupId();
        result = result * 59 + ($routerGroupId == null ? 43 : $routerGroupId.hashCode());
        List<String> $routerGroupTypes = this.getRouterGroupTypes();
        result = result * 59 + ($routerGroupTypes == null ? 43 : ((Object)$routerGroupTypes).hashCode());
        return result;
    }

    public String toString() {
        return "Domain(id=" + this.getId() + ", name=" + this.getName() + ", owningOrganizationId=" + this.getOwningOrganizationId() + ", routerGroupId=" + this.getRouterGroupId() + ", routerGroupTypes=" + this.getRouterGroupTypes() + ")";
    }

    public static class DomainBuilder {
        private String id;
        private String name;
        private String owningOrganizationId;
        private String routerGroupId;
        private ArrayList<String> routerGroupTypes;

        DomainBuilder() {
        }

        public DomainBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DomainBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DomainBuilder owningOrganizationId(String owningOrganizationId) {
            this.owningOrganizationId = owningOrganizationId;
            return this;
        }

        public DomainBuilder routerGroupId(String routerGroupId) {
            this.routerGroupId = routerGroupId;
            return this;
        }

        public DomainBuilder routerGroupType(String routerGroupType) {
            if (this.routerGroupTypes == null) {
                this.routerGroupTypes = new ArrayList();
            }
            this.routerGroupTypes.add(routerGroupType);
            return this;
        }

        public DomainBuilder routerGroupTypes(Collection<? extends String> routerGroupTypes) {
            if (this.routerGroupTypes == null) {
                this.routerGroupTypes = new ArrayList();
            }
            this.routerGroupTypes.addAll(routerGroupTypes);
            return this;
        }

        public Domain build() {
            List<String> routerGroupTypes;
            switch (this.routerGroupTypes == null ? 0 : this.routerGroupTypes.size()) {
                case 0: {
                    routerGroupTypes = Collections.emptyList();
                    break;
                }
                case 1: {
                    routerGroupTypes = Collections.singletonList(this.routerGroupTypes.get(0));
                    break;
                }
                default: {
                    routerGroupTypes = Collections.unmodifiableList(new ArrayList<String>(this.routerGroupTypes));
                }
            }
            return new Domain(this.id, this.name, this.owningOrganizationId, this.routerGroupId, routerGroupTypes);
        }

        public String toString() {
            return "Domain.DomainBuilder(id=" + this.id + ", name=" + this.name + ", owningOrganizationId=" + this.owningOrganizationId + ", routerGroupId=" + this.routerGroupId + ", routerGroupTypes=" + this.routerGroupTypes + ")";
        }
    }
}

