/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.domains;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class GetDomainRequest
implements Validatable {
    private final String domainId;

    GetDomainRequest(String domainId) {
        this.domainId = domainId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.domainId == null) {
            builder.message("domain id must be specified");
        }
        return builder.build();
    }

    public static GetDomainRequestBuilder builder() {
        return new GetDomainRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetDomainRequest)) {
            return false;
        }
        GetDomainRequest other = (GetDomainRequest)o;
        String this$domainId = this.getDomainId();
        String other$domainId = other.getDomainId();
        return !(this$domainId == null ? other$domainId != null : !this$domainId.equals(other$domainId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $domainId = this.getDomainId();
        result = result * 59 + ($domainId == null ? 43 : $domainId.hashCode());
        return result;
    }

    public String toString() {
        return "GetDomainRequest(domainId=" + this.getDomainId() + ")";
    }

    @JsonIgnore
    public String getDomainId() {
        return this.domainId;
    }

    public static class GetDomainRequestBuilder {
        private String domainId;

        GetDomainRequestBuilder() {
        }

        public GetDomainRequestBuilder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public GetDomainRequest build() {
            return new GetDomainRequest(this.domainId);
        }

        public String toString() {
            return "GetDomainRequest.GetDomainRequestBuilder(domainId=" + this.domainId + ")";
        }
    }
}

