/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.domains;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListDomainSpacesRequest
extends PaginatedRequest
implements Validatable {
    private final List<String> applicationIds;
    private final List<String> developerIds;
    private final String domainId;
    private final List<String> names;
    private final List<String> organizationIds;

    ListDomainSpacesRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> applicationIds, List<String> developerIds, String domainId, List<String> names, List<String> organizationIds) {
        super(orderDirection, page, resultsPerPage);
        this.applicationIds = applicationIds;
        this.developerIds = developerIds;
        this.domainId = domainId;
        this.names = names;
        this.organizationIds = organizationIds;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.domainId == null) {
            builder.message("domain id must be specified");
        }
        return builder.build();
    }

    public static ListDomainSpacesRequestBuilder builder() {
        return new ListDomainSpacesRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListDomainSpacesRequest)) {
            return false;
        }
        ListDomainSpacesRequest other = (ListDomainSpacesRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$applicationIds = this.getApplicationIds();
        List<String> other$applicationIds = other.getApplicationIds();
        if (this$applicationIds == null ? other$applicationIds != null : !((Object)this$applicationIds).equals(other$applicationIds)) {
            return false;
        }
        List<String> this$developerIds = this.getDeveloperIds();
        List<String> other$developerIds = other.getDeveloperIds();
        if (this$developerIds == null ? other$developerIds != null : !((Object)this$developerIds).equals(other$developerIds)) {
            return false;
        }
        String this$domainId = this.getDomainId();
        String other$domainId = other.getDomainId();
        if (this$domainId == null ? other$domainId != null : !this$domainId.equals(other$domainId)) {
            return false;
        }
        List<String> this$names = this.getNames();
        List<String> other$names = other.getNames();
        if (this$names == null ? other$names != null : !((Object)this$names).equals(other$names)) {
            return false;
        }
        List<String> this$organizationIds = this.getOrganizationIds();
        List<String> other$organizationIds = other.getOrganizationIds();
        return !(this$organizationIds == null ? other$organizationIds != null : !((Object)this$organizationIds).equals(other$organizationIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListDomainSpacesRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $applicationIds = this.getApplicationIds();
        result = result * 59 + ($applicationIds == null ? 43 : ((Object)$applicationIds).hashCode());
        List<String> $developerIds = this.getDeveloperIds();
        result = result * 59 + ($developerIds == null ? 43 : ((Object)$developerIds).hashCode());
        String $domainId = this.getDomainId();
        result = result * 59 + ($domainId == null ? 43 : $domainId.hashCode());
        List<String> $names = this.getNames();
        result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
        List<String> $organizationIds = this.getOrganizationIds();
        result = result * 59 + ($organizationIds == null ? 43 : ((Object)$organizationIds).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListDomainSpacesRequest(super=" + super.toString() + ", applicationIds=" + this.getApplicationIds() + ", developerIds=" + this.getDeveloperIds() + ", domainId=" + this.getDomainId() + ", names=" + this.getNames() + ", organizationIds=" + this.getOrganizationIds() + ")";
    }

    @InFilterParameter(value="app_guid")
    public List<String> getApplicationIds() {
        return this.applicationIds;
    }

    @InFilterParameter(value="developer_guid")
    public List<String> getDeveloperIds() {
        return this.developerIds;
    }

    @JsonIgnore
    public String getDomainId() {
        return this.domainId;
    }

    @InFilterParameter(value="name")
    public List<String> getNames() {
        return this.names;
    }

    @InFilterParameter(value="organization_guid")
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    public static class ListDomainSpacesRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private ArrayList<String> applicationIds;
        private ArrayList<String> developerIds;
        private String domainId;
        private ArrayList<String> names;
        private ArrayList<String> organizationIds;

        ListDomainSpacesRequestBuilder() {
        }

        public ListDomainSpacesRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListDomainSpacesRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListDomainSpacesRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListDomainSpacesRequestBuilder applicationId(String applicationId) {
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList();
            }
            this.applicationIds.add(applicationId);
            return this;
        }

        public ListDomainSpacesRequestBuilder applicationIds(Collection<? extends String> applicationIds) {
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList();
            }
            this.applicationIds.addAll(applicationIds);
            return this;
        }

        public ListDomainSpacesRequestBuilder developerId(String developerId) {
            if (this.developerIds == null) {
                this.developerIds = new ArrayList();
            }
            this.developerIds.add(developerId);
            return this;
        }

        public ListDomainSpacesRequestBuilder developerIds(Collection<? extends String> developerIds) {
            if (this.developerIds == null) {
                this.developerIds = new ArrayList();
            }
            this.developerIds.addAll(developerIds);
            return this;
        }

        public ListDomainSpacesRequestBuilder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public ListDomainSpacesRequestBuilder name(String name) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.add(name);
            return this;
        }

        public ListDomainSpacesRequestBuilder names(Collection<? extends String> names) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.addAll(names);
            return this;
        }

        public ListDomainSpacesRequestBuilder organizationId(String organizationId) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList();
            }
            this.organizationIds.add(organizationId);
            return this;
        }

        public ListDomainSpacesRequestBuilder organizationIds(Collection<? extends String> organizationIds) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList();
            }
            this.organizationIds.addAll(organizationIds);
            return this;
        }

        public ListDomainSpacesRequest build() {
            List<String> organizationIds;
            List<String> names;
            List<String> developerIds;
            List<String> applicationIds;
            switch (this.applicationIds == null ? 0 : this.applicationIds.size()) {
                case 0: {
                    applicationIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    applicationIds = Collections.singletonList(this.applicationIds.get(0));
                    break;
                }
                default: {
                    applicationIds = Collections.unmodifiableList(new ArrayList<String>(this.applicationIds));
                }
            }
            switch (this.developerIds == null ? 0 : this.developerIds.size()) {
                case 0: {
                    developerIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    developerIds = Collections.singletonList(this.developerIds.get(0));
                    break;
                }
                default: {
                    developerIds = Collections.unmodifiableList(new ArrayList<String>(this.developerIds));
                }
            }
            switch (this.names == null ? 0 : this.names.size()) {
                case 0: {
                    names = Collections.emptyList();
                    break;
                }
                case 1: {
                    names = Collections.singletonList(this.names.get(0));
                    break;
                }
                default: {
                    names = Collections.unmodifiableList(new ArrayList<String>(this.names));
                }
            }
            switch (this.organizationIds == null ? 0 : this.organizationIds.size()) {
                case 0: {
                    organizationIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    organizationIds = Collections.singletonList(this.organizationIds.get(0));
                    break;
                }
                default: {
                    organizationIds = Collections.unmodifiableList(new ArrayList<String>(this.organizationIds));
                }
            }
            return new ListDomainSpacesRequest(this.orderDirection, this.page, this.resultsPerPage, applicationIds, developerIds, this.domainId, names, organizationIds);
        }

        public String toString() {
            return "ListDomainSpacesRequest.ListDomainSpacesRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", applicationIds=" + this.applicationIds + ", developerIds=" + this.developerIds + ", domainId=" + this.domainId + ", names=" + this.names + ", organizationIds=" + this.organizationIds + ")";
        }
    }
}

