/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public final class EventEntity {
    private final String actee;
    private final String acteeName;
    private final String acteeType;
    private final String actor;
    private final String actorName;
    private final String actorType;
    private final Map<String, Object> metadatas;
    private final String organizationId;
    private final String spaceId;
    private final String timestamp;
    private final String type;

    EventEntity(@JsonProperty(value="actee") String actee, @JsonProperty(value="actee_name") String acteeName, @JsonProperty(value="actee_type") String acteeType, @JsonProperty(value="actor") String actor, @JsonProperty(value="actor_name") String actorName, @JsonProperty(value="actor_type") String actorType, @JsonProperty(value="metadata") Map<String, Object> metadatas, @JsonProperty(value="organization_guid") String organizationId, @JsonProperty(value="space_guid") String spaceId, @JsonProperty(value="timestamp") String timestamp, @JsonProperty(value="type") String type) {
        this.actee = actee;
        this.acteeName = acteeName;
        this.acteeType = acteeType;
        this.actor = actor;
        this.actorName = actorName;
        this.actorType = actorType;
        this.metadatas = Optional.ofNullable(metadatas).orElse(Collections.emptyMap());
        this.organizationId = organizationId;
        this.spaceId = spaceId;
        this.timestamp = timestamp;
        this.type = type;
    }

    public static EventEntityBuilder builder() {
        return new EventEntityBuilder();
    }

    public String getActee() {
        return this.actee;
    }

    public String getActeeName() {
        return this.acteeName;
    }

    public String getActeeType() {
        return this.acteeType;
    }

    public String getActor() {
        return this.actor;
    }

    public String getActorName() {
        return this.actorName;
    }

    public String getActorType() {
        return this.actorType;
    }

    public Map<String, Object> getMetadatas() {
        return this.metadatas;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventEntity)) {
            return false;
        }
        EventEntity other = (EventEntity)o;
        String this$actee = this.getActee();
        String other$actee = other.getActee();
        if (this$actee == null ? other$actee != null : !this$actee.equals(other$actee)) {
            return false;
        }
        String this$acteeName = this.getActeeName();
        String other$acteeName = other.getActeeName();
        if (this$acteeName == null ? other$acteeName != null : !this$acteeName.equals(other$acteeName)) {
            return false;
        }
        String this$acteeType = this.getActeeType();
        String other$acteeType = other.getActeeType();
        if (this$acteeType == null ? other$acteeType != null : !this$acteeType.equals(other$acteeType)) {
            return false;
        }
        String this$actor = this.getActor();
        String other$actor = other.getActor();
        if (this$actor == null ? other$actor != null : !this$actor.equals(other$actor)) {
            return false;
        }
        String this$actorName = this.getActorName();
        String other$actorName = other.getActorName();
        if (this$actorName == null ? other$actorName != null : !this$actorName.equals(other$actorName)) {
            return false;
        }
        String this$actorType = this.getActorType();
        String other$actorType = other.getActorType();
        if (this$actorType == null ? other$actorType != null : !this$actorType.equals(other$actorType)) {
            return false;
        }
        Map<String, Object> this$metadatas = this.getMetadatas();
        Map<String, Object> other$metadatas = other.getMetadatas();
        if (this$metadatas == null ? other$metadatas != null : !((Object)this$metadatas).equals(other$metadatas)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        String this$spaceId = this.getSpaceId();
        String other$spaceId = other.getSpaceId();
        if (this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $actee = this.getActee();
        result = result * 59 + ($actee == null ? 43 : $actee.hashCode());
        String $acteeName = this.getActeeName();
        result = result * 59 + ($acteeName == null ? 43 : $acteeName.hashCode());
        String $acteeType = this.getActeeType();
        result = result * 59 + ($acteeType == null ? 43 : $acteeType.hashCode());
        String $actor = this.getActor();
        result = result * 59 + ($actor == null ? 43 : $actor.hashCode());
        String $actorName = this.getActorName();
        result = result * 59 + ($actorName == null ? 43 : $actorName.hashCode());
        String $actorType = this.getActorType();
        result = result * 59 + ($actorType == null ? 43 : $actorType.hashCode());
        Map<String, Object> $metadatas = this.getMetadatas();
        result = result * 59 + ($metadatas == null ? 43 : ((Object)$metadatas).hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        String $spaceId = this.getSpaceId();
        result = result * 59 + ($spaceId == null ? 43 : $spaceId.hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "EventEntity(actee=" + this.getActee() + ", acteeName=" + this.getActeeName() + ", acteeType=" + this.getActeeType() + ", actor=" + this.getActor() + ", actorName=" + this.getActorName() + ", actorType=" + this.getActorType() + ", metadatas=" + this.getMetadatas() + ", organizationId=" + this.getOrganizationId() + ", spaceId=" + this.getSpaceId() + ", timestamp=" + this.getTimestamp() + ", type=" + this.getType() + ")";
    }

    public static class EventEntityBuilder {
        private String actee;
        private String acteeName;
        private String acteeType;
        private String actor;
        private String actorName;
        private String actorType;
        private ArrayList<String> metadatas$key;
        private ArrayList<Object> metadatas$value;
        private String organizationId;
        private String spaceId;
        private String timestamp;
        private String type;

        EventEntityBuilder() {
        }

        public EventEntityBuilder actee(String actee) {
            this.actee = actee;
            return this;
        }

        public EventEntityBuilder acteeName(String acteeName) {
            this.acteeName = acteeName;
            return this;
        }

        public EventEntityBuilder acteeType(String acteeType) {
            this.acteeType = acteeType;
            return this;
        }

        public EventEntityBuilder actor(String actor) {
            this.actor = actor;
            return this;
        }

        public EventEntityBuilder actorName(String actorName) {
            this.actorName = actorName;
            return this;
        }

        public EventEntityBuilder actorType(String actorType) {
            this.actorType = actorType;
            return this;
        }

        public EventEntityBuilder metadata(String metadataKey, Object metadataValue) {
            if (this.metadatas$key == null) {
                this.metadatas$key = new ArrayList();
                this.metadatas$value = new ArrayList();
            }
            this.metadatas$key.add(metadataKey);
            this.metadatas$value.add(metadataValue);
            return this;
        }

        public EventEntityBuilder metadatas(Map<? extends String, ? extends Object> metadatas) {
            if (this.metadatas$key == null) {
                this.metadatas$key = new ArrayList();
                this.metadatas$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : metadatas.entrySet()) {
                this.metadatas$key.add($lombokEntry.getKey());
                this.metadatas$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public EventEntityBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public EventEntityBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public EventEntityBuilder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public EventEntityBuilder type(String type) {
            this.type = type;
            return this;
        }

        public EventEntity build() {
            Map<String, Object> metadatas;
            switch (this.metadatas$key == null ? 0 : this.metadatas$key.size()) {
                case 0: {
                    metadatas = Collections.emptyMap();
                    break;
                }
                case 1: {
                    metadatas = Collections.singletonMap(this.metadatas$key.get(0), this.metadatas$value.get(0));
                    break;
                }
                default: {
                    metadatas = new LinkedHashMap(this.metadatas$key.size() < 0x40000000 ? 1 + this.metadatas$key.size() + (this.metadatas$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.metadatas$key.size(); ++$i) {
                        metadatas.put(this.metadatas$key.get($i), this.metadatas$value.get($i));
                    }
                    metadatas = Collections.unmodifiableMap(metadatas);
                }
            }
            return new EventEntity(this.actee, this.acteeName, this.acteeType, this.actor, this.actorName, this.actorType, metadatas, this.organizationId, this.spaceId, this.timestamp, this.type);
        }

        public String toString() {
            return "EventEntity.EventEntityBuilder(actee=" + this.actee + ", acteeName=" + this.acteeName + ", acteeType=" + this.acteeType + ", actor=" + this.actor + ", actorName=" + this.actorName + ", actorType=" + this.actorType + ", metadatas$key=" + this.metadatas$key + ", metadatas$value=" + this.metadatas$value + ", organizationId=" + this.organizationId + ", spaceId=" + this.spaceId + ", timestamp=" + this.timestamp + ", type=" + this.type + ")";
        }
    }
}

