/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.GreaterThanOrEqualToFilterParameter;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListEventsRequest
extends PaginatedRequest
implements Validatable {
    private final List<String> actees;
    private final List<String> timestamps;
    private final List<String> types;

    ListEventsRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> actees, List<String> timestamps, List<String> types) {
        super(orderDirection, page, resultsPerPage);
        this.actees = actees;
        this.timestamps = timestamps;
        this.types = types;
    }

    @Override
    public ValidationResult isValid() {
        return ValidationResult.builder().build();
    }

    public static ListEventsRequestBuilder builder() {
        return new ListEventsRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListEventsRequest)) {
            return false;
        }
        ListEventsRequest other = (ListEventsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$actees = this.getActees();
        List<String> other$actees = other.getActees();
        if (this$actees == null ? other$actees != null : !((Object)this$actees).equals(other$actees)) {
            return false;
        }
        List<String> this$timestamps = this.getTimestamps();
        List<String> other$timestamps = other.getTimestamps();
        if (this$timestamps == null ? other$timestamps != null : !((Object)this$timestamps).equals(other$timestamps)) {
            return false;
        }
        List<String> this$types = this.getTypes();
        List<String> other$types = other.getTypes();
        return !(this$types == null ? other$types != null : !((Object)this$types).equals(other$types));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListEventsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $actees = this.getActees();
        result = result * 59 + ($actees == null ? 43 : ((Object)$actees).hashCode());
        List<String> $timestamps = this.getTimestamps();
        result = result * 59 + ($timestamps == null ? 43 : ((Object)$timestamps).hashCode());
        List<String> $types = this.getTypes();
        result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListEventsRequest(super=" + super.toString() + ", actees=" + this.getActees() + ", timestamps=" + this.getTimestamps() + ", types=" + this.getTypes() + ")";
    }

    @InFilterParameter(value="actee")
    public List<String> getActees() {
        return this.actees;
    }

    @GreaterThanOrEqualToFilterParameter(value="timestamp")
    public List<String> getTimestamps() {
        return this.timestamps;
    }

    @InFilterParameter(value="type")
    public List<String> getTypes() {
        return this.types;
    }

    public static class ListEventsRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private ArrayList<String> actees;
        private ArrayList<String> timestamps;
        private ArrayList<String> types;

        ListEventsRequestBuilder() {
        }

        public ListEventsRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListEventsRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListEventsRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListEventsRequestBuilder actee(String actee) {
            if (this.actees == null) {
                this.actees = new ArrayList();
            }
            this.actees.add(actee);
            return this;
        }

        public ListEventsRequestBuilder actees(Collection<? extends String> actees) {
            if (this.actees == null) {
                this.actees = new ArrayList();
            }
            this.actees.addAll(actees);
            return this;
        }

        public ListEventsRequestBuilder timestamp(String timestamp) {
            if (this.timestamps == null) {
                this.timestamps = new ArrayList();
            }
            this.timestamps.add(timestamp);
            return this;
        }

        public ListEventsRequestBuilder timestamps(Collection<? extends String> timestamps) {
            if (this.timestamps == null) {
                this.timestamps = new ArrayList();
            }
            this.timestamps.addAll(timestamps);
            return this;
        }

        public ListEventsRequestBuilder type(String type) {
            if (this.types == null) {
                this.types = new ArrayList();
            }
            this.types.add(type);
            return this;
        }

        public ListEventsRequestBuilder types(Collection<? extends String> types) {
            if (this.types == null) {
                this.types = new ArrayList();
            }
            this.types.addAll(types);
            return this;
        }

        public ListEventsRequest build() {
            List<String> types;
            List<String> timestamps;
            List<String> actees;
            switch (this.actees == null ? 0 : this.actees.size()) {
                case 0: {
                    actees = Collections.emptyList();
                    break;
                }
                case 1: {
                    actees = Collections.singletonList(this.actees.get(0));
                    break;
                }
                default: {
                    actees = Collections.unmodifiableList(new ArrayList<String>(this.actees));
                }
            }
            switch (this.timestamps == null ? 0 : this.timestamps.size()) {
                case 0: {
                    timestamps = Collections.emptyList();
                    break;
                }
                case 1: {
                    timestamps = Collections.singletonList(this.timestamps.get(0));
                    break;
                }
                default: {
                    timestamps = Collections.unmodifiableList(new ArrayList<String>(this.timestamps));
                }
            }
            switch (this.types == null ? 0 : this.types.size()) {
                case 0: {
                    types = Collections.emptyList();
                    break;
                }
                case 1: {
                    types = Collections.singletonList(this.types.get(0));
                    break;
                }
                default: {
                    types = Collections.unmodifiableList(new ArrayList<String>(this.types));
                }
            }
            return new ListEventsRequest(this.orderDirection, this.page, this.resultsPerPage, actees, timestamps, types);
        }

        public String toString() {
            return "ListEventsRequest.ListEventsRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", actees=" + this.actees + ", timestamps=" + this.timestamps + ", types=" + this.types + ")";
        }
    }
}

