/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.featureflags;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.regex.Pattern;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class GetFeatureFlagRequest
implements Validatable {
    private static final Pattern ALPHAS_AND_UNDERS = Pattern.compile("[a-z_]*");
    private final String name;

    GetFeatureFlagRequest(String name) {
        this.name = name;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.name == null) {
            builder.message("name must be specified");
        } else if (!GetFeatureFlagRequest.validName(this.name)) {
            builder.message("name must consist only of alphabetic characters and underscores");
        }
        return builder.build();
    }

    private static boolean validName(String name) {
        return ALPHAS_AND_UNDERS.matcher(name).matches();
    }

    public static GetFeatureFlagRequestBuilder builder() {
        return new GetFeatureFlagRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetFeatureFlagRequest)) {
            return false;
        }
        GetFeatureFlagRequest other = (GetFeatureFlagRequest)o;
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "GetFeatureFlagRequest(name=" + this.getName() + ")";
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    public static class GetFeatureFlagRequestBuilder {
        private String name;

        GetFeatureFlagRequestBuilder() {
        }

        public GetFeatureFlagRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public GetFeatureFlagRequest build() {
            return new GetFeatureFlagRequest(this.name);
        }

        public String toString() {
            return "GetFeatureFlagRequest.GetFeatureFlagRequestBuilder(name=" + this.name + ")";
        }
    }
}

