/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.featureflags;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class SetFeatureFlagRequest
implements Validatable {
    private final Boolean enabled;
    private final String errorMessage;
    private final String name;

    SetFeatureFlagRequest(Boolean enabled, String errorMessage, String name) {
        this.enabled = enabled;
        this.errorMessage = errorMessage;
        this.name = name;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.name == null) {
            builder.message("name must be specified");
        }
        if (this.enabled == null) {
            builder.message("enabled must be specified");
        }
        return builder.build();
    }

    public static SetFeatureFlagRequestBuilder builder() {
        return new SetFeatureFlagRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetFeatureFlagRequest)) {
            return false;
        }
        SetFeatureFlagRequest other = (SetFeatureFlagRequest)o;
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "SetFeatureFlagRequest(enabled=" + this.getEnabled() + ", errorMessage=" + this.getErrorMessage() + ", name=" + this.getName() + ")";
    }

    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="error_message")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    public static class SetFeatureFlagRequestBuilder {
        private Boolean enabled;
        private String errorMessage;
        private String name;

        SetFeatureFlagRequestBuilder() {
        }

        public SetFeatureFlagRequestBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public SetFeatureFlagRequestBuilder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public SetFeatureFlagRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SetFeatureFlagRequest build() {
            return new SetFeatureFlagRequest(this.enabled, this.errorMessage, this.name);
        }

        public String toString() {
            return "SetFeatureFlagRequest.SetFeatureFlagRequestBuilder(enabled=" + this.enabled + ", errorMessage=" + this.errorMessage + ", name=" + this.name + ")";
        }
    }
}

