/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizationquotadefinitions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListOrganizationQuotaDefinitionsRequest
extends PaginatedRequest
implements Validatable {
    private final List<String> names;

    ListOrganizationQuotaDefinitionsRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> names) {
        super(orderDirection, page, resultsPerPage);
        this.names = names;
    }

    @Override
    public ValidationResult isValid() {
        return ValidationResult.builder().build();
    }

    public static ListOrganizationQuotaDefinitionsRequestBuilder builder() {
        return new ListOrganizationQuotaDefinitionsRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListOrganizationQuotaDefinitionsRequest)) {
            return false;
        }
        ListOrganizationQuotaDefinitionsRequest other = (ListOrganizationQuotaDefinitionsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$names = this.getNames();
        List<String> other$names = other.getNames();
        return !(this$names == null ? other$names != null : !((Object)this$names).equals(other$names));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListOrganizationQuotaDefinitionsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $names = this.getNames();
        result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListOrganizationQuotaDefinitionsRequest(super=" + super.toString() + ", names=" + this.getNames() + ")";
    }

    @InFilterParameter(value="name")
    public List<String> getNames() {
        return this.names;
    }

    public static class ListOrganizationQuotaDefinitionsRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private ArrayList<String> names;

        ListOrganizationQuotaDefinitionsRequestBuilder() {
        }

        public ListOrganizationQuotaDefinitionsRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListOrganizationQuotaDefinitionsRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListOrganizationQuotaDefinitionsRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListOrganizationQuotaDefinitionsRequestBuilder name(String name) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.add(name);
            return this;
        }

        public ListOrganizationQuotaDefinitionsRequestBuilder names(Collection<? extends String> names) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.addAll(names);
            return this;
        }

        public ListOrganizationQuotaDefinitionsRequest build() {
            List<String> names;
            switch (this.names == null ? 0 : this.names.size()) {
                case 0: {
                    names = Collections.emptyList();
                    break;
                }
                case 1: {
                    names = Collections.singletonList(this.names.get(0));
                    break;
                }
                default: {
                    names = Collections.unmodifiableList(new ArrayList<String>(this.names));
                }
            }
            return new ListOrganizationQuotaDefinitionsRequest(this.orderDirection, this.page, this.resultsPerPage, names);
        }

        public String toString() {
            return "ListOrganizationQuotaDefinitionsRequest.ListOrganizationQuotaDefinitionsRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", names=" + this.names + ")";
        }
    }
}

