/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizationquotadefinitions;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.v2.PaginatedResponse;
import org.cloudfoundry.client.v2.organizationquotadefinitions.OrganizationQuotaDefinitionResource;

public final class ListOrganizationQuotaDefinitionsResponse
extends PaginatedResponse<OrganizationQuotaDefinitionResource> {
    ListOrganizationQuotaDefinitionsResponse(@JsonProperty(value="next_url") String nextUrl, @JsonProperty(value="prev_url") String previousUrl, @JsonProperty(value="resources") List<OrganizationQuotaDefinitionResource> resources, @JsonProperty(value="total_pages") Integer totalPages, @JsonProperty(value="total_results") Integer totalResults) {
        super(nextUrl, previousUrl, resources, totalPages, totalResults);
    }

    public static ListOrganizationQuotaDefinitionsResponseBuilder builder() {
        return new ListOrganizationQuotaDefinitionsResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListOrganizationQuotaDefinitionsResponse)) {
            return false;
        }
        ListOrganizationQuotaDefinitionsResponse other = (ListOrganizationQuotaDefinitionsResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListOrganizationQuotaDefinitionsResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ListOrganizationQuotaDefinitionsResponse(super=" + super.toString() + ")";
    }

    public static class ListOrganizationQuotaDefinitionsResponseBuilder {
        private String nextUrl;
        private String previousUrl;
        private ArrayList<OrganizationQuotaDefinitionResource> resources;
        private Integer totalPages;
        private Integer totalResults;

        ListOrganizationQuotaDefinitionsResponseBuilder() {
        }

        public ListOrganizationQuotaDefinitionsResponseBuilder nextUrl(String nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        public ListOrganizationQuotaDefinitionsResponseBuilder previousUrl(String previousUrl) {
            this.previousUrl = previousUrl;
            return this;
        }

        public ListOrganizationQuotaDefinitionsResponseBuilder resource(OrganizationQuotaDefinitionResource resource) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
            return this;
        }

        public ListOrganizationQuotaDefinitionsResponseBuilder resources(Collection<? extends OrganizationQuotaDefinitionResource> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.addAll(resources);
            return this;
        }

        public ListOrganizationQuotaDefinitionsResponseBuilder totalPages(Integer totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        public ListOrganizationQuotaDefinitionsResponseBuilder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public ListOrganizationQuotaDefinitionsResponse build() {
            List<OrganizationQuotaDefinitionResource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
                case 0: {
                    resources = Collections.emptyList();
                    break;
                }
                case 1: {
                    resources = Collections.singletonList(this.resources.get(0));
                    break;
                }
                default: {
                    resources = Collections.unmodifiableList(new ArrayList<OrganizationQuotaDefinitionResource>(this.resources));
                }
            }
            return new ListOrganizationQuotaDefinitionsResponse(this.nextUrl, this.previousUrl, resources, this.totalPages, this.totalResults);
        }

        public String toString() {
            return "ListOrganizationQuotaDefinitionsResponse.ListOrganizationQuotaDefinitionsResponseBuilder(nextUrl=" + this.nextUrl + ", previousUrl=" + this.previousUrl + ", resources=" + this.resources + ", totalPages=" + this.totalPages + ", totalResults=" + this.totalResults + ")";
        }
    }
}

