/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizationquotadefinitions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class UpdateOrganizationQuotaDefinitionRequest
implements Validatable {
    private final Integer applicationInstanceLimit;
    private final Integer applicationTaskLimit;
    private final Integer instanceMemoryLimit;
    private final Integer memoryLimit;
    private final String name;
    private final Boolean nonBasicServicesAllowed;
    private final String organizationQuotaDefinitionId;
    private final Integer totalPrivateDomains;
    private final Integer totalRoutes;
    private final Integer totalServiceKeys;
    private final Integer totalServices;
    private final Boolean trialDatabaseAllowed;

    UpdateOrganizationQuotaDefinitionRequest(Integer applicationInstanceLimit, Integer applicationTaskLimit, Integer instanceMemoryLimit, Integer memoryLimit, String name, Boolean nonBasicServicesAllowed, String organizationQuotaDefinitionId, Integer totalPrivateDomains, Integer totalRoutes, Integer totalServiceKeys, Integer totalServices, Boolean trialDatabaseAllowed) {
        this.applicationInstanceLimit = applicationInstanceLimit;
        this.applicationTaskLimit = applicationTaskLimit;
        this.instanceMemoryLimit = instanceMemoryLimit;
        this.memoryLimit = memoryLimit;
        this.name = name;
        this.nonBasicServicesAllowed = nonBasicServicesAllowed;
        this.organizationQuotaDefinitionId = organizationQuotaDefinitionId;
        this.totalPrivateDomains = totalPrivateDomains;
        this.totalRoutes = totalRoutes;
        this.totalServiceKeys = totalServiceKeys;
        this.totalServices = totalServices;
        this.trialDatabaseAllowed = trialDatabaseAllowed;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.organizationQuotaDefinitionId == null) {
            builder.message("organization quota definition id must be specified");
        }
        return builder.build();
    }

    public static UpdateOrganizationQuotaDefinitionRequestBuilder builder() {
        return new UpdateOrganizationQuotaDefinitionRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateOrganizationQuotaDefinitionRequest)) {
            return false;
        }
        UpdateOrganizationQuotaDefinitionRequest other = (UpdateOrganizationQuotaDefinitionRequest)o;
        Integer this$applicationInstanceLimit = this.getApplicationInstanceLimit();
        Integer other$applicationInstanceLimit = other.getApplicationInstanceLimit();
        if (this$applicationInstanceLimit == null ? other$applicationInstanceLimit != null : !((Object)this$applicationInstanceLimit).equals(other$applicationInstanceLimit)) {
            return false;
        }
        Integer this$applicationTaskLimit = this.getApplicationTaskLimit();
        Integer other$applicationTaskLimit = other.getApplicationTaskLimit();
        if (this$applicationTaskLimit == null ? other$applicationTaskLimit != null : !((Object)this$applicationTaskLimit).equals(other$applicationTaskLimit)) {
            return false;
        }
        Integer this$instanceMemoryLimit = this.getInstanceMemoryLimit();
        Integer other$instanceMemoryLimit = other.getInstanceMemoryLimit();
        if (this$instanceMemoryLimit == null ? other$instanceMemoryLimit != null : !((Object)this$instanceMemoryLimit).equals(other$instanceMemoryLimit)) {
            return false;
        }
        Integer this$memoryLimit = this.getMemoryLimit();
        Integer other$memoryLimit = other.getMemoryLimit();
        if (this$memoryLimit == null ? other$memoryLimit != null : !((Object)this$memoryLimit).equals(other$memoryLimit)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Boolean this$nonBasicServicesAllowed = this.getNonBasicServicesAllowed();
        Boolean other$nonBasicServicesAllowed = other.getNonBasicServicesAllowed();
        if (this$nonBasicServicesAllowed == null ? other$nonBasicServicesAllowed != null : !((Object)this$nonBasicServicesAllowed).equals(other$nonBasicServicesAllowed)) {
            return false;
        }
        String this$organizationQuotaDefinitionId = this.getOrganizationQuotaDefinitionId();
        String other$organizationQuotaDefinitionId = other.getOrganizationQuotaDefinitionId();
        if (this$organizationQuotaDefinitionId == null ? other$organizationQuotaDefinitionId != null : !this$organizationQuotaDefinitionId.equals(other$organizationQuotaDefinitionId)) {
            return false;
        }
        Integer this$totalPrivateDomains = this.getTotalPrivateDomains();
        Integer other$totalPrivateDomains = other.getTotalPrivateDomains();
        if (this$totalPrivateDomains == null ? other$totalPrivateDomains != null : !((Object)this$totalPrivateDomains).equals(other$totalPrivateDomains)) {
            return false;
        }
        Integer this$totalRoutes = this.getTotalRoutes();
        Integer other$totalRoutes = other.getTotalRoutes();
        if (this$totalRoutes == null ? other$totalRoutes != null : !((Object)this$totalRoutes).equals(other$totalRoutes)) {
            return false;
        }
        Integer this$totalServiceKeys = this.getTotalServiceKeys();
        Integer other$totalServiceKeys = other.getTotalServiceKeys();
        if (this$totalServiceKeys == null ? other$totalServiceKeys != null : !((Object)this$totalServiceKeys).equals(other$totalServiceKeys)) {
            return false;
        }
        Integer this$totalServices = this.getTotalServices();
        Integer other$totalServices = other.getTotalServices();
        if (this$totalServices == null ? other$totalServices != null : !((Object)this$totalServices).equals(other$totalServices)) {
            return false;
        }
        Boolean this$trialDatabaseAllowed = this.getTrialDatabaseAllowed();
        Boolean other$trialDatabaseAllowed = other.getTrialDatabaseAllowed();
        return !(this$trialDatabaseAllowed == null ? other$trialDatabaseAllowed != null : !((Object)this$trialDatabaseAllowed).equals(other$trialDatabaseAllowed));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $applicationInstanceLimit = this.getApplicationInstanceLimit();
        result = result * 59 + ($applicationInstanceLimit == null ? 43 : ((Object)$applicationInstanceLimit).hashCode());
        Integer $applicationTaskLimit = this.getApplicationTaskLimit();
        result = result * 59 + ($applicationTaskLimit == null ? 43 : ((Object)$applicationTaskLimit).hashCode());
        Integer $instanceMemoryLimit = this.getInstanceMemoryLimit();
        result = result * 59 + ($instanceMemoryLimit == null ? 43 : ((Object)$instanceMemoryLimit).hashCode());
        Integer $memoryLimit = this.getMemoryLimit();
        result = result * 59 + ($memoryLimit == null ? 43 : ((Object)$memoryLimit).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Boolean $nonBasicServicesAllowed = this.getNonBasicServicesAllowed();
        result = result * 59 + ($nonBasicServicesAllowed == null ? 43 : ((Object)$nonBasicServicesAllowed).hashCode());
        String $organizationQuotaDefinitionId = this.getOrganizationQuotaDefinitionId();
        result = result * 59 + ($organizationQuotaDefinitionId == null ? 43 : $organizationQuotaDefinitionId.hashCode());
        Integer $totalPrivateDomains = this.getTotalPrivateDomains();
        result = result * 59 + ($totalPrivateDomains == null ? 43 : ((Object)$totalPrivateDomains).hashCode());
        Integer $totalRoutes = this.getTotalRoutes();
        result = result * 59 + ($totalRoutes == null ? 43 : ((Object)$totalRoutes).hashCode());
        Integer $totalServiceKeys = this.getTotalServiceKeys();
        result = result * 59 + ($totalServiceKeys == null ? 43 : ((Object)$totalServiceKeys).hashCode());
        Integer $totalServices = this.getTotalServices();
        result = result * 59 + ($totalServices == null ? 43 : ((Object)$totalServices).hashCode());
        Boolean $trialDatabaseAllowed = this.getTrialDatabaseAllowed();
        result = result * 59 + ($trialDatabaseAllowed == null ? 43 : ((Object)$trialDatabaseAllowed).hashCode());
        return result;
    }

    public String toString() {
        return "UpdateOrganizationQuotaDefinitionRequest(applicationInstanceLimit=" + this.getApplicationInstanceLimit() + ", applicationTaskLimit=" + this.getApplicationTaskLimit() + ", instanceMemoryLimit=" + this.getInstanceMemoryLimit() + ", memoryLimit=" + this.getMemoryLimit() + ", name=" + this.getName() + ", nonBasicServicesAllowed=" + this.getNonBasicServicesAllowed() + ", organizationQuotaDefinitionId=" + this.getOrganizationQuotaDefinitionId() + ", totalPrivateDomains=" + this.getTotalPrivateDomains() + ", totalRoutes=" + this.getTotalRoutes() + ", totalServiceKeys=" + this.getTotalServiceKeys() + ", totalServices=" + this.getTotalServices() + ", trialDatabaseAllowed=" + this.getTrialDatabaseAllowed() + ")";
    }

    @JsonProperty(value="app_instance_limit")
    public Integer getApplicationInstanceLimit() {
        return this.applicationInstanceLimit;
    }

    @JsonProperty(value="app_task_limit")
    public Integer getApplicationTaskLimit() {
        return this.applicationTaskLimit;
    }

    @JsonProperty(value="instance_memory_limit")
    public Integer getInstanceMemoryLimit() {
        return this.instanceMemoryLimit;
    }

    @JsonProperty(value="memory_limit")
    public Integer getMemoryLimit() {
        return this.memoryLimit;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="non_basic_services_allowed")
    public Boolean getNonBasicServicesAllowed() {
        return this.nonBasicServicesAllowed;
    }

    @JsonIgnore
    public String getOrganizationQuotaDefinitionId() {
        return this.organizationQuotaDefinitionId;
    }

    @JsonProperty(value="total_private_domains")
    public Integer getTotalPrivateDomains() {
        return this.totalPrivateDomains;
    }

    @JsonProperty(value="total_routes")
    public Integer getTotalRoutes() {
        return this.totalRoutes;
    }

    @JsonProperty(value="total_service_keys")
    public Integer getTotalServiceKeys() {
        return this.totalServiceKeys;
    }

    @JsonProperty(value="total_services")
    public Integer getTotalServices() {
        return this.totalServices;
    }

    @JsonProperty(value="trial_db_allowed")
    @Deprecated
    public Boolean getTrialDatabaseAllowed() {
        return this.trialDatabaseAllowed;
    }

    public static class UpdateOrganizationQuotaDefinitionRequestBuilder {
        private Integer applicationInstanceLimit;
        private Integer applicationTaskLimit;
        private Integer instanceMemoryLimit;
        private Integer memoryLimit;
        private String name;
        private Boolean nonBasicServicesAllowed;
        private String organizationQuotaDefinitionId;
        private Integer totalPrivateDomains;
        private Integer totalRoutes;
        private Integer totalServiceKeys;
        private Integer totalServices;
        private Boolean trialDatabaseAllowed;

        UpdateOrganizationQuotaDefinitionRequestBuilder() {
        }

        public UpdateOrganizationQuotaDefinitionRequestBuilder applicationInstanceLimit(Integer applicationInstanceLimit) {
            this.applicationInstanceLimit = applicationInstanceLimit;
            return this;
        }

        public UpdateOrganizationQuotaDefinitionRequestBuilder applicationTaskLimit(Integer applicationTaskLimit) {
            this.applicationTaskLimit = applicationTaskLimit;
            return this;
        }

        public UpdateOrganizationQuotaDefinitionRequestBuilder instanceMemoryLimit(Integer instanceMemoryLimit) {
            this.instanceMemoryLimit = instanceMemoryLimit;
            return this;
        }

        public UpdateOrganizationQuotaDefinitionRequestBuilder memoryLimit(Integer memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this;
        }

        public UpdateOrganizationQuotaDefinitionRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public UpdateOrganizationQuotaDefinitionRequestBuilder nonBasicServicesAllowed(Boolean nonBasicServicesAllowed) {
            this.nonBasicServicesAllowed = nonBasicServicesAllowed;
            return this;
        }

        public UpdateOrganizationQuotaDefinitionRequestBuilder organizationQuotaDefinitionId(String organizationQuotaDefinitionId) {
            this.organizationQuotaDefinitionId = organizationQuotaDefinitionId;
            return this;
        }

        public UpdateOrganizationQuotaDefinitionRequestBuilder totalPrivateDomains(Integer totalPrivateDomains) {
            this.totalPrivateDomains = totalPrivateDomains;
            return this;
        }

        public UpdateOrganizationQuotaDefinitionRequestBuilder totalRoutes(Integer totalRoutes) {
            this.totalRoutes = totalRoutes;
            return this;
        }

        public UpdateOrganizationQuotaDefinitionRequestBuilder totalServiceKeys(Integer totalServiceKeys) {
            this.totalServiceKeys = totalServiceKeys;
            return this;
        }

        public UpdateOrganizationQuotaDefinitionRequestBuilder totalServices(Integer totalServices) {
            this.totalServices = totalServices;
            return this;
        }

        public UpdateOrganizationQuotaDefinitionRequestBuilder trialDatabaseAllowed(Boolean trialDatabaseAllowed) {
            this.trialDatabaseAllowed = trialDatabaseAllowed;
            return this;
        }

        public UpdateOrganizationQuotaDefinitionRequest build() {
            return new UpdateOrganizationQuotaDefinitionRequest(this.applicationInstanceLimit, this.applicationTaskLimit, this.instanceMemoryLimit, this.memoryLimit, this.name, this.nonBasicServicesAllowed, this.organizationQuotaDefinitionId, this.totalPrivateDomains, this.totalRoutes, this.totalServiceKeys, this.totalServices, this.trialDatabaseAllowed);
        }

        public String toString() {
            return "UpdateOrganizationQuotaDefinitionRequest.UpdateOrganizationQuotaDefinitionRequestBuilder(applicationInstanceLimit=" + this.applicationInstanceLimit + ", applicationTaskLimit=" + this.applicationTaskLimit + ", instanceMemoryLimit=" + this.instanceMemoryLimit + ", memoryLimit=" + this.memoryLimit + ", name=" + this.name + ", nonBasicServicesAllowed=" + this.nonBasicServicesAllowed + ", organizationQuotaDefinitionId=" + this.organizationQuotaDefinitionId + ", totalPrivateDomains=" + this.totalPrivateDomains + ", totalRoutes=" + this.totalRoutes + ", totalServiceKeys=" + this.totalServiceKeys + ", totalServices=" + this.totalServices + ", trialDatabaseAllowed=" + this.trialDatabaseAllowed + ")";
        }
    }
}

