/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class AssociateOrganizationAuditorByUsernameRequest
implements Validatable {
    private final String organizationId;
    private final String username;

    AssociateOrganizationAuditorByUsernameRequest(String organizationId, String username) {
        this.organizationId = organizationId;
        this.username = username;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        if (this.username == null) {
            builder.message("username must be specified");
        }
        return builder.build();
    }

    public static AssociateOrganizationAuditorByUsernameRequestBuilder builder() {
        return new AssociateOrganizationAuditorByUsernameRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssociateOrganizationAuditorByUsernameRequest)) {
            return false;
        }
        AssociateOrganizationAuditorByUsernameRequest other = (AssociateOrganizationAuditorByUsernameRequest)o;
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        return !(this$username == null ? other$username != null : !this$username.equals(other$username));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        return result;
    }

    public String toString() {
        return "AssociateOrganizationAuditorByUsernameRequest(organizationId=" + this.getOrganizationId() + ", username=" + this.getUsername() + ")";
    }

    @JsonIgnore
    public String getOrganizationId() {
        return this.organizationId;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    public static class AssociateOrganizationAuditorByUsernameRequestBuilder {
        private String organizationId;
        private String username;

        AssociateOrganizationAuditorByUsernameRequestBuilder() {
        }

        public AssociateOrganizationAuditorByUsernameRequestBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public AssociateOrganizationAuditorByUsernameRequestBuilder username(String username) {
            this.username = username;
            return this;
        }

        public AssociateOrganizationAuditorByUsernameRequest build() {
            return new AssociateOrganizationAuditorByUsernameRequest(this.organizationId, this.username);
        }

        public String toString() {
            return "AssociateOrganizationAuditorByUsernameRequest.AssociateOrganizationAuditorByUsernameRequestBuilder(organizationId=" + this.organizationId + ", username=" + this.username + ")";
        }
    }
}

