/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class AssociateOrganizationBillingManagerRequest
implements Validatable {
    private final String billingManagerId;
    private final String organizationId;

    AssociateOrganizationBillingManagerRequest(String billingManagerId, String organizationId) {
        this.billingManagerId = billingManagerId;
        this.organizationId = organizationId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.billingManagerId == null) {
            builder.message("billing manager id must be specified");
        }
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        return builder.build();
    }

    public static AssociateOrganizationBillingManagerRequestBuilder builder() {
        return new AssociateOrganizationBillingManagerRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssociateOrganizationBillingManagerRequest)) {
            return false;
        }
        AssociateOrganizationBillingManagerRequest other = (AssociateOrganizationBillingManagerRequest)o;
        String this$billingManagerId = this.getBillingManagerId();
        String other$billingManagerId = other.getBillingManagerId();
        if (this$billingManagerId == null ? other$billingManagerId != null : !this$billingManagerId.equals(other$billingManagerId)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        return !(this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $billingManagerId = this.getBillingManagerId();
        result = result * 59 + ($billingManagerId == null ? 43 : $billingManagerId.hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        return result;
    }

    public String toString() {
        return "AssociateOrganizationBillingManagerRequest(billingManagerId=" + this.getBillingManagerId() + ", organizationId=" + this.getOrganizationId() + ")";
    }

    @JsonIgnore
    public String getBillingManagerId() {
        return this.billingManagerId;
    }

    @JsonIgnore
    public String getOrganizationId() {
        return this.organizationId;
    }

    public static class AssociateOrganizationBillingManagerRequestBuilder {
        private String billingManagerId;
        private String organizationId;

        AssociateOrganizationBillingManagerRequestBuilder() {
        }

        public AssociateOrganizationBillingManagerRequestBuilder billingManagerId(String billingManagerId) {
            this.billingManagerId = billingManagerId;
            return this;
        }

        public AssociateOrganizationBillingManagerRequestBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public AssociateOrganizationBillingManagerRequest build() {
            return new AssociateOrganizationBillingManagerRequest(this.billingManagerId, this.organizationId);
        }

        public String toString() {
            return "AssociateOrganizationBillingManagerRequest.AssociateOrganizationBillingManagerRequestBuilder(billingManagerId=" + this.billingManagerId + ", organizationId=" + this.organizationId + ")";
        }
    }
}

