/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class AssociateOrganizationManagerRequest
implements Validatable {
    private final String managerId;
    private final String organizationId;

    AssociateOrganizationManagerRequest(String managerId, String organizationId) {
        this.managerId = managerId;
        this.organizationId = organizationId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        if (this.managerId == null) {
            builder.message("manager id must be specified");
        }
        return builder.build();
    }

    public static AssociateOrganizationManagerRequestBuilder builder() {
        return new AssociateOrganizationManagerRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssociateOrganizationManagerRequest)) {
            return false;
        }
        AssociateOrganizationManagerRequest other = (AssociateOrganizationManagerRequest)o;
        String this$managerId = this.getManagerId();
        String other$managerId = other.getManagerId();
        if (this$managerId == null ? other$managerId != null : !this$managerId.equals(other$managerId)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        return !(this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $managerId = this.getManagerId();
        result = result * 59 + ($managerId == null ? 43 : $managerId.hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        return result;
    }

    public String toString() {
        return "AssociateOrganizationManagerRequest(managerId=" + this.getManagerId() + ", organizationId=" + this.getOrganizationId() + ")";
    }

    @JsonIgnore
    public String getManagerId() {
        return this.managerId;
    }

    @JsonIgnore
    public String getOrganizationId() {
        return this.organizationId;
    }

    public static class AssociateOrganizationManagerRequestBuilder {
        private String managerId;
        private String organizationId;

        AssociateOrganizationManagerRequestBuilder() {
        }

        public AssociateOrganizationManagerRequestBuilder managerId(String managerId) {
            this.managerId = managerId;
            return this;
        }

        public AssociateOrganizationManagerRequestBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public AssociateOrganizationManagerRequest build() {
            return new AssociateOrganizationManagerRequest(this.managerId, this.organizationId);
        }

        public String toString() {
            return "AssociateOrganizationManagerRequest.AssociateOrganizationManagerRequestBuilder(managerId=" + this.managerId + ", organizationId=" + this.organizationId + ")";
        }
    }
}

