/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class AssociateOrganizationPrivateDomainRequest
implements Validatable {
    private final String organizationId;
    private final String privateDomainId;

    AssociateOrganizationPrivateDomainRequest(String organizationId, String privateDomainId) {
        this.organizationId = organizationId;
        this.privateDomainId = privateDomainId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        if (this.privateDomainId == null) {
            builder.message("private domain id must be specified");
        }
        return builder.build();
    }

    public static AssociateOrganizationPrivateDomainRequestBuilder builder() {
        return new AssociateOrganizationPrivateDomainRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssociateOrganizationPrivateDomainRequest)) {
            return false;
        }
        AssociateOrganizationPrivateDomainRequest other = (AssociateOrganizationPrivateDomainRequest)o;
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        String this$privateDomainId = this.getPrivateDomainId();
        String other$privateDomainId = other.getPrivateDomainId();
        return !(this$privateDomainId == null ? other$privateDomainId != null : !this$privateDomainId.equals(other$privateDomainId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        String $privateDomainId = this.getPrivateDomainId();
        result = result * 59 + ($privateDomainId == null ? 43 : $privateDomainId.hashCode());
        return result;
    }

    public String toString() {
        return "AssociateOrganizationPrivateDomainRequest(organizationId=" + this.getOrganizationId() + ", privateDomainId=" + this.getPrivateDomainId() + ")";
    }

    @JsonIgnore
    public String getOrganizationId() {
        return this.organizationId;
    }

    @JsonIgnore
    public String getPrivateDomainId() {
        return this.privateDomainId;
    }

    public static class AssociateOrganizationPrivateDomainRequestBuilder {
        private String organizationId;
        private String privateDomainId;

        AssociateOrganizationPrivateDomainRequestBuilder() {
        }

        public AssociateOrganizationPrivateDomainRequestBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public AssociateOrganizationPrivateDomainRequestBuilder privateDomainId(String privateDomainId) {
            this.privateDomainId = privateDomainId;
            return this;
        }

        public AssociateOrganizationPrivateDomainRequest build() {
            return new AssociateOrganizationPrivateDomainRequest(this.organizationId, this.privateDomainId);
        }

        public String toString() {
            return "AssociateOrganizationPrivateDomainRequest.AssociateOrganizationPrivateDomainRequestBuilder(organizationId=" + this.organizationId + ", privateDomainId=" + this.privateDomainId + ")";
        }
    }
}

