/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class AssociateOrganizationUserRequest
implements Validatable {
    private final String organizationId;
    private final String userId;

    AssociateOrganizationUserRequest(String organizationId, String userId) {
        this.organizationId = organizationId;
        this.userId = userId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        if (this.userId == null) {
            builder.message("user id must be specified");
        }
        return builder.build();
    }

    public static AssociateOrganizationUserRequestBuilder builder() {
        return new AssociateOrganizationUserRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssociateOrganizationUserRequest)) {
            return false;
        }
        AssociateOrganizationUserRequest other = (AssociateOrganizationUserRequest)o;
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        return !(this$userId == null ? other$userId != null : !this$userId.equals(other$userId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        return result;
    }

    public String toString() {
        return "AssociateOrganizationUserRequest(organizationId=" + this.getOrganizationId() + ", userId=" + this.getUserId() + ")";
    }

    @JsonIgnore
    public String getOrganizationId() {
        return this.organizationId;
    }

    @JsonIgnore
    public String getUserId() {
        return this.userId;
    }

    public static class AssociateOrganizationUserRequestBuilder {
        private String organizationId;
        private String userId;

        AssociateOrganizationUserRequestBuilder() {
        }

        public AssociateOrganizationUserRequestBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public AssociateOrganizationUserRequestBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public AssociateOrganizationUserRequest build() {
            return new AssociateOrganizationUserRequest(this.organizationId, this.userId);
        }

        public String toString() {
            return "AssociateOrganizationUserRequest.AssociateOrganizationUserRequestBuilder(organizationId=" + this.organizationId + ", userId=" + this.userId + ")";
        }
    }
}

