/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class CreateOrganizationRequest
implements Validatable {
    private final String name;
    private final String quotaDefinitionId;
    private final String status;

    CreateOrganizationRequest(String name, String quotaDefinitionId, String status) {
        this.name = name;
        this.quotaDefinitionId = quotaDefinitionId;
        this.status = status;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.name == null) {
            builder.message("name must be specified");
        }
        return builder.build();
    }

    public static CreateOrganizationRequestBuilder builder() {
        return new CreateOrganizationRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateOrganizationRequest)) {
            return false;
        }
        CreateOrganizationRequest other = (CreateOrganizationRequest)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$quotaDefinitionId = this.getQuotaDefinitionId();
        String other$quotaDefinitionId = other.getQuotaDefinitionId();
        if (this$quotaDefinitionId == null ? other$quotaDefinitionId != null : !this$quotaDefinitionId.equals(other$quotaDefinitionId)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $quotaDefinitionId = this.getQuotaDefinitionId();
        result = result * 59 + ($quotaDefinitionId == null ? 43 : $quotaDefinitionId.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    public String toString() {
        return "CreateOrganizationRequest(name=" + this.getName() + ", quotaDefinitionId=" + this.getQuotaDefinitionId() + ", status=" + this.getStatus() + ")";
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="quota_definition_guid")
    public String getQuotaDefinitionId() {
        return this.quotaDefinitionId;
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    public static class CreateOrganizationRequestBuilder {
        private String name;
        private String quotaDefinitionId;
        private String status;

        CreateOrganizationRequestBuilder() {
        }

        public CreateOrganizationRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CreateOrganizationRequestBuilder quotaDefinitionId(String quotaDefinitionId) {
            this.quotaDefinitionId = quotaDefinitionId;
            return this;
        }

        public CreateOrganizationRequestBuilder status(String status) {
            this.status = status;
            return this;
        }

        public CreateOrganizationRequest build() {
            return new CreateOrganizationRequest(this.name, this.quotaDefinitionId, this.status);
        }

        public String toString() {
            return "CreateOrganizationRequest.CreateOrganizationRequestBuilder(name=" + this.name + ", quotaDefinitionId=" + this.quotaDefinitionId + ", status=" + this.status + ")";
        }
    }
}

