/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class DeleteOrganizationRequest
implements Validatable {
    private final Boolean async;
    private final String organizationId;

    DeleteOrganizationRequest(Boolean async, String organizationId) {
        this.async = async;
        this.organizationId = organizationId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        return builder.build();
    }

    public static DeleteOrganizationRequestBuilder builder() {
        return new DeleteOrganizationRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteOrganizationRequest)) {
            return false;
        }
        DeleteOrganizationRequest other = (DeleteOrganizationRequest)o;
        Boolean this$async = this.getAsync();
        Boolean other$async = other.getAsync();
        if (this$async == null ? other$async != null : !((Object)this$async).equals(other$async)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        return !(this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $async = this.getAsync();
        result = result * 59 + ($async == null ? 43 : ((Object)$async).hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        return result;
    }

    public String toString() {
        return "DeleteOrganizationRequest(async=" + this.getAsync() + ", organizationId=" + this.getOrganizationId() + ")";
    }

    @QueryParameter(value="async")
    public Boolean getAsync() {
        return this.async;
    }

    @JsonIgnore
    public String getOrganizationId() {
        return this.organizationId;
    }

    public static class DeleteOrganizationRequestBuilder {
        private Boolean async;
        private String organizationId;

        DeleteOrganizationRequestBuilder() {
        }

        public DeleteOrganizationRequestBuilder async(Boolean async) {
            this.async = async;
            return this;
        }

        public DeleteOrganizationRequestBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public DeleteOrganizationRequest build() {
            return new DeleteOrganizationRequest(this.async, this.organizationId);
        }

        public String toString() {
            return "DeleteOrganizationRequest.DeleteOrganizationRequestBuilder(async=" + this.async + ", organizationId=" + this.organizationId + ")";
        }
    }
}

