/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class GetOrganizationRequest
implements Validatable {
    private final String organizationId;

    GetOrganizationRequest(String organizationId) {
        this.organizationId = organizationId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        return builder.build();
    }

    public static GetOrganizationRequestBuilder builder() {
        return new GetOrganizationRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetOrganizationRequest)) {
            return false;
        }
        GetOrganizationRequest other = (GetOrganizationRequest)o;
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        return !(this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        return result;
    }

    public String toString() {
        return "GetOrganizationRequest(organizationId=" + this.getOrganizationId() + ")";
    }

    @JsonIgnore
    public String getOrganizationId() {
        return this.organizationId;
    }

    public static class GetOrganizationRequestBuilder {
        private String organizationId;

        GetOrganizationRequestBuilder() {
        }

        public GetOrganizationRequestBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public GetOrganizationRequest build() {
            return new GetOrganizationRequest(this.organizationId);
        }

        public String toString() {
            return "GetOrganizationRequest.GetOrganizationRequestBuilder(organizationId=" + this.organizationId + ")";
        }
    }
}

