/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class GetOrganizationUserRolesRequest
extends PaginatedRequest
implements Validatable {
    private final String organizationId;

    GetOrganizationUserRolesRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, String organizationId) {
        super(orderDirection, page, resultsPerPage);
        this.organizationId = organizationId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        return builder.build();
    }

    public static GetOrganizationUserRolesRequestBuilder builder() {
        return new GetOrganizationUserRolesRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetOrganizationUserRolesRequest)) {
            return false;
        }
        GetOrganizationUserRolesRequest other = (GetOrganizationUserRolesRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        return !(this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GetOrganizationUserRolesRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "GetOrganizationUserRolesRequest(super=" + super.toString() + ", organizationId=" + this.getOrganizationId() + ")";
    }

    @JsonIgnore
    public String getOrganizationId() {
        return this.organizationId;
    }

    public static class GetOrganizationUserRolesRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private String organizationId;

        GetOrganizationUserRolesRequestBuilder() {
        }

        public GetOrganizationUserRolesRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public GetOrganizationUserRolesRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public GetOrganizationUserRolesRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public GetOrganizationUserRolesRequestBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public GetOrganizationUserRolesRequest build() {
            return new GetOrganizationUserRolesRequest(this.orderDirection, this.page, this.resultsPerPage, this.organizationId);
        }

        public String toString() {
            return "GetOrganizationUserRolesRequest.GetOrganizationUserRolesRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", organizationId=" + this.organizationId + ")";
        }
    }
}

