/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.v2.PaginatedResponse;
import org.cloudfoundry.client.v2.organizations.UserOrganizationRoleResource;

public final class GetOrganizationUserRolesResponse
extends PaginatedResponse<UserOrganizationRoleResource> {
    GetOrganizationUserRolesResponse(@JsonProperty(value="next_url") String nextUrl, @JsonProperty(value="prev_url") String previousUrl, @JsonProperty(value="resources") List<UserOrganizationRoleResource> resources, @JsonProperty(value="total_pages") Integer totalPages, @JsonProperty(value="total_results") Integer totalResults) {
        super(nextUrl, previousUrl, resources, totalPages, totalResults);
    }

    public static GetOrganizationUserRolesResponseBuilder builder() {
        return new GetOrganizationUserRolesResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetOrganizationUserRolesResponse)) {
            return false;
        }
        GetOrganizationUserRolesResponse other = (GetOrganizationUserRolesResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GetOrganizationUserRolesResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "GetOrganizationUserRolesResponse(super=" + super.toString() + ")";
    }

    public static class GetOrganizationUserRolesResponseBuilder {
        private String nextUrl;
        private String previousUrl;
        private ArrayList<UserOrganizationRoleResource> resources;
        private Integer totalPages;
        private Integer totalResults;

        GetOrganizationUserRolesResponseBuilder() {
        }

        public GetOrganizationUserRolesResponseBuilder nextUrl(String nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        public GetOrganizationUserRolesResponseBuilder previousUrl(String previousUrl) {
            this.previousUrl = previousUrl;
            return this;
        }

        public GetOrganizationUserRolesResponseBuilder resource(UserOrganizationRoleResource resource) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
            return this;
        }

        public GetOrganizationUserRolesResponseBuilder resources(Collection<? extends UserOrganizationRoleResource> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.addAll(resources);
            return this;
        }

        public GetOrganizationUserRolesResponseBuilder totalPages(Integer totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        public GetOrganizationUserRolesResponseBuilder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public GetOrganizationUserRolesResponse build() {
            List<UserOrganizationRoleResource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
                case 0: {
                    resources = Collections.emptyList();
                    break;
                }
                case 1: {
                    resources = Collections.singletonList(this.resources.get(0));
                    break;
                }
                default: {
                    resources = Collections.unmodifiableList(new ArrayList<UserOrganizationRoleResource>(this.resources));
                }
            }
            return new GetOrganizationUserRolesResponse(this.nextUrl, this.previousUrl, resources, this.totalPages, this.totalResults);
        }

        public String toString() {
            return "GetOrganizationUserRolesResponse.GetOrganizationUserRolesResponseBuilder(nextUrl=" + this.nextUrl + ", previousUrl=" + this.previousUrl + ", resources=" + this.resources + ", totalPages=" + this.totalPages + ", totalResults=" + this.totalResults + ")";
        }
    }
}

