/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListOrganizationDomainsRequest
extends PaginatedRequest
implements Validatable {
    private final List<String> names;
    private final String organizationId;
    private final List<String> owningOrganizationIds;

    ListOrganizationDomainsRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> names, String organizationId, List<String> owningOrganizationIds) {
        super(orderDirection, page, resultsPerPage);
        this.names = names;
        this.organizationId = organizationId;
        this.owningOrganizationIds = owningOrganizationIds;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        return builder.build();
    }

    public static ListOrganizationDomainsRequestBuilder builder() {
        return new ListOrganizationDomainsRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListOrganizationDomainsRequest)) {
            return false;
        }
        ListOrganizationDomainsRequest other = (ListOrganizationDomainsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$names = this.getNames();
        List<String> other$names = other.getNames();
        if (this$names == null ? other$names != null : !((Object)this$names).equals(other$names)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        List<String> this$owningOrganizationIds = this.getOwningOrganizationIds();
        List<String> other$owningOrganizationIds = other.getOwningOrganizationIds();
        return !(this$owningOrganizationIds == null ? other$owningOrganizationIds != null : !((Object)this$owningOrganizationIds).equals(other$owningOrganizationIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListOrganizationDomainsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $names = this.getNames();
        result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        List<String> $owningOrganizationIds = this.getOwningOrganizationIds();
        result = result * 59 + ($owningOrganizationIds == null ? 43 : ((Object)$owningOrganizationIds).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListOrganizationDomainsRequest(super=" + super.toString() + ", names=" + this.getNames() + ", organizationId=" + this.getOrganizationId() + ", owningOrganizationIds=" + this.getOwningOrganizationIds() + ")";
    }

    @InFilterParameter(value="name")
    public List<String> getNames() {
        return this.names;
    }

    @JsonIgnore
    public String getOrganizationId() {
        return this.organizationId;
    }

    @InFilterParameter(value="owning_organization_guid")
    public List<String> getOwningOrganizationIds() {
        return this.owningOrganizationIds;
    }

    public static class ListOrganizationDomainsRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private ArrayList<String> names;
        private String organizationId;
        private ArrayList<String> owningOrganizationIds;

        ListOrganizationDomainsRequestBuilder() {
        }

        public ListOrganizationDomainsRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListOrganizationDomainsRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListOrganizationDomainsRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListOrganizationDomainsRequestBuilder name(String name) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.add(name);
            return this;
        }

        public ListOrganizationDomainsRequestBuilder names(Collection<? extends String> names) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.addAll(names);
            return this;
        }

        public ListOrganizationDomainsRequestBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public ListOrganizationDomainsRequestBuilder owningOrganizationId(String owningOrganizationId) {
            if (this.owningOrganizationIds == null) {
                this.owningOrganizationIds = new ArrayList();
            }
            this.owningOrganizationIds.add(owningOrganizationId);
            return this;
        }

        public ListOrganizationDomainsRequestBuilder owningOrganizationIds(Collection<? extends String> owningOrganizationIds) {
            if (this.owningOrganizationIds == null) {
                this.owningOrganizationIds = new ArrayList();
            }
            this.owningOrganizationIds.addAll(owningOrganizationIds);
            return this;
        }

        public ListOrganizationDomainsRequest build() {
            List<String> owningOrganizationIds;
            List<String> names;
            switch (this.names == null ? 0 : this.names.size()) {
                case 0: {
                    names = Collections.emptyList();
                    break;
                }
                case 1: {
                    names = Collections.singletonList(this.names.get(0));
                    break;
                }
                default: {
                    names = Collections.unmodifiableList(new ArrayList<String>(this.names));
                }
            }
            switch (this.owningOrganizationIds == null ? 0 : this.owningOrganizationIds.size()) {
                case 0: {
                    owningOrganizationIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    owningOrganizationIds = Collections.singletonList(this.owningOrganizationIds.get(0));
                    break;
                }
                default: {
                    owningOrganizationIds = Collections.unmodifiableList(new ArrayList<String>(this.owningOrganizationIds));
                }
            }
            return new ListOrganizationDomainsRequest(this.orderDirection, this.page, this.resultsPerPage, names, this.organizationId, owningOrganizationIds);
        }

        public String toString() {
            return "ListOrganizationDomainsRequest.ListOrganizationDomainsRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", names=" + this.names + ", organizationId=" + this.organizationId + ", owningOrganizationIds=" + this.owningOrganizationIds + ")";
        }
    }
}

