/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListOrganizationManagersRequest
extends PaginatedRequest
implements Validatable {
    private final List<String> auditedOrganizationIds;
    private final List<String> auditedSpaceIds;
    private final List<String> billingManagedOrganizationIds;
    private final List<String> managedOrganizationIds;
    private final List<String> managedSpaceIds;
    private final String organizationId;
    private final List<String> spaceIds;

    ListOrganizationManagersRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> auditedOrganizationIds, List<String> auditedSpaceIds, List<String> billingManagedOrganizationIds, List<String> managedOrganizationIds, List<String> managedSpaceIds, String organizationId, List<String> spaceIds) {
        super(orderDirection, page, resultsPerPage);
        this.auditedOrganizationIds = auditedOrganizationIds;
        this.auditedSpaceIds = auditedSpaceIds;
        this.billingManagedOrganizationIds = billingManagedOrganizationIds;
        this.managedOrganizationIds = managedOrganizationIds;
        this.managedSpaceIds = managedSpaceIds;
        this.organizationId = organizationId;
        this.spaceIds = spaceIds;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        return builder.build();
    }

    public static ListOrganizationManagersRequestBuilder builder() {
        return new ListOrganizationManagersRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListOrganizationManagersRequest)) {
            return false;
        }
        ListOrganizationManagersRequest other = (ListOrganizationManagersRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$auditedOrganizationIds = this.getAuditedOrganizationIds();
        List<String> other$auditedOrganizationIds = other.getAuditedOrganizationIds();
        if (this$auditedOrganizationIds == null ? other$auditedOrganizationIds != null : !((Object)this$auditedOrganizationIds).equals(other$auditedOrganizationIds)) {
            return false;
        }
        List<String> this$auditedSpaceIds = this.getAuditedSpaceIds();
        List<String> other$auditedSpaceIds = other.getAuditedSpaceIds();
        if (this$auditedSpaceIds == null ? other$auditedSpaceIds != null : !((Object)this$auditedSpaceIds).equals(other$auditedSpaceIds)) {
            return false;
        }
        List<String> this$billingManagedOrganizationIds = this.getBillingManagedOrganizationIds();
        List<String> other$billingManagedOrganizationIds = other.getBillingManagedOrganizationIds();
        if (this$billingManagedOrganizationIds == null ? other$billingManagedOrganizationIds != null : !((Object)this$billingManagedOrganizationIds).equals(other$billingManagedOrganizationIds)) {
            return false;
        }
        List<String> this$managedOrganizationIds = this.getManagedOrganizationIds();
        List<String> other$managedOrganizationIds = other.getManagedOrganizationIds();
        if (this$managedOrganizationIds == null ? other$managedOrganizationIds != null : !((Object)this$managedOrganizationIds).equals(other$managedOrganizationIds)) {
            return false;
        }
        List<String> this$managedSpaceIds = this.getManagedSpaceIds();
        List<String> other$managedSpaceIds = other.getManagedSpaceIds();
        if (this$managedSpaceIds == null ? other$managedSpaceIds != null : !((Object)this$managedSpaceIds).equals(other$managedSpaceIds)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        List<String> this$spaceIds = this.getSpaceIds();
        List<String> other$spaceIds = other.getSpaceIds();
        return !(this$spaceIds == null ? other$spaceIds != null : !((Object)this$spaceIds).equals(other$spaceIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListOrganizationManagersRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $auditedOrganizationIds = this.getAuditedOrganizationIds();
        result = result * 59 + ($auditedOrganizationIds == null ? 43 : ((Object)$auditedOrganizationIds).hashCode());
        List<String> $auditedSpaceIds = this.getAuditedSpaceIds();
        result = result * 59 + ($auditedSpaceIds == null ? 43 : ((Object)$auditedSpaceIds).hashCode());
        List<String> $billingManagedOrganizationIds = this.getBillingManagedOrganizationIds();
        result = result * 59 + ($billingManagedOrganizationIds == null ? 43 : ((Object)$billingManagedOrganizationIds).hashCode());
        List<String> $managedOrganizationIds = this.getManagedOrganizationIds();
        result = result * 59 + ($managedOrganizationIds == null ? 43 : ((Object)$managedOrganizationIds).hashCode());
        List<String> $managedSpaceIds = this.getManagedSpaceIds();
        result = result * 59 + ($managedSpaceIds == null ? 43 : ((Object)$managedSpaceIds).hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        List<String> $spaceIds = this.getSpaceIds();
        result = result * 59 + ($spaceIds == null ? 43 : ((Object)$spaceIds).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListOrganizationManagersRequest(super=" + super.toString() + ", auditedOrganizationIds=" + this.getAuditedOrganizationIds() + ", auditedSpaceIds=" + this.getAuditedSpaceIds() + ", billingManagedOrganizationIds=" + this.getBillingManagedOrganizationIds() + ", managedOrganizationIds=" + this.getManagedOrganizationIds() + ", managedSpaceIds=" + this.getManagedSpaceIds() + ", organizationId=" + this.getOrganizationId() + ", spaceIds=" + this.getSpaceIds() + ")";
    }

    @InFilterParameter(value="audited_organization_guid")
    public List<String> getAuditedOrganizationIds() {
        return this.auditedOrganizationIds;
    }

    @InFilterParameter(value="audited_space_guid")
    public List<String> getAuditedSpaceIds() {
        return this.auditedSpaceIds;
    }

    @InFilterParameter(value="billing_managed_organization_guid")
    public List<String> getBillingManagedOrganizationIds() {
        return this.billingManagedOrganizationIds;
    }

    @InFilterParameter(value="managed_organization_guid")
    public List<String> getManagedOrganizationIds() {
        return this.managedOrganizationIds;
    }

    @InFilterParameter(value="managed_space_guid")
    public List<String> getManagedSpaceIds() {
        return this.managedSpaceIds;
    }

    @JsonIgnore
    public String getOrganizationId() {
        return this.organizationId;
    }

    @InFilterParameter(value="space_guid")
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }

    public static class ListOrganizationManagersRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private ArrayList<String> auditedOrganizationIds;
        private ArrayList<String> auditedSpaceIds;
        private ArrayList<String> billingManagedOrganizationIds;
        private ArrayList<String> managedOrganizationIds;
        private ArrayList<String> managedSpaceIds;
        private String organizationId;
        private ArrayList<String> spaceIds;

        ListOrganizationManagersRequestBuilder() {
        }

        public ListOrganizationManagersRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListOrganizationManagersRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListOrganizationManagersRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListOrganizationManagersRequestBuilder auditedOrganizationId(String auditedOrganizationId) {
            if (this.auditedOrganizationIds == null) {
                this.auditedOrganizationIds = new ArrayList();
            }
            this.auditedOrganizationIds.add(auditedOrganizationId);
            return this;
        }

        public ListOrganizationManagersRequestBuilder auditedOrganizationIds(Collection<? extends String> auditedOrganizationIds) {
            if (this.auditedOrganizationIds == null) {
                this.auditedOrganizationIds = new ArrayList();
            }
            this.auditedOrganizationIds.addAll(auditedOrganizationIds);
            return this;
        }

        public ListOrganizationManagersRequestBuilder auditedSpaceId(String auditedSpaceId) {
            if (this.auditedSpaceIds == null) {
                this.auditedSpaceIds = new ArrayList();
            }
            this.auditedSpaceIds.add(auditedSpaceId);
            return this;
        }

        public ListOrganizationManagersRequestBuilder auditedSpaceIds(Collection<? extends String> auditedSpaceIds) {
            if (this.auditedSpaceIds == null) {
                this.auditedSpaceIds = new ArrayList();
            }
            this.auditedSpaceIds.addAll(auditedSpaceIds);
            return this;
        }

        public ListOrganizationManagersRequestBuilder billingManagedOrganizationId(String billingManagedOrganizationId) {
            if (this.billingManagedOrganizationIds == null) {
                this.billingManagedOrganizationIds = new ArrayList();
            }
            this.billingManagedOrganizationIds.add(billingManagedOrganizationId);
            return this;
        }

        public ListOrganizationManagersRequestBuilder billingManagedOrganizationIds(Collection<? extends String> billingManagedOrganizationIds) {
            if (this.billingManagedOrganizationIds == null) {
                this.billingManagedOrganizationIds = new ArrayList();
            }
            this.billingManagedOrganizationIds.addAll(billingManagedOrganizationIds);
            return this;
        }

        public ListOrganizationManagersRequestBuilder managedOrganizationId(String managedOrganizationId) {
            if (this.managedOrganizationIds == null) {
                this.managedOrganizationIds = new ArrayList();
            }
            this.managedOrganizationIds.add(managedOrganizationId);
            return this;
        }

        public ListOrganizationManagersRequestBuilder managedOrganizationIds(Collection<? extends String> managedOrganizationIds) {
            if (this.managedOrganizationIds == null) {
                this.managedOrganizationIds = new ArrayList();
            }
            this.managedOrganizationIds.addAll(managedOrganizationIds);
            return this;
        }

        public ListOrganizationManagersRequestBuilder managedSpaceId(String managedSpaceId) {
            if (this.managedSpaceIds == null) {
                this.managedSpaceIds = new ArrayList();
            }
            this.managedSpaceIds.add(managedSpaceId);
            return this;
        }

        public ListOrganizationManagersRequestBuilder managedSpaceIds(Collection<? extends String> managedSpaceIds) {
            if (this.managedSpaceIds == null) {
                this.managedSpaceIds = new ArrayList();
            }
            this.managedSpaceIds.addAll(managedSpaceIds);
            return this;
        }

        public ListOrganizationManagersRequestBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public ListOrganizationManagersRequestBuilder spaceId(String spaceId) {
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList();
            }
            this.spaceIds.add(spaceId);
            return this;
        }

        public ListOrganizationManagersRequestBuilder spaceIds(Collection<? extends String> spaceIds) {
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList();
            }
            this.spaceIds.addAll(spaceIds);
            return this;
        }

        public ListOrganizationManagersRequest build() {
            List<String> spaceIds;
            List<String> managedSpaceIds;
            List<String> managedOrganizationIds;
            List<String> billingManagedOrganizationIds;
            List<String> auditedSpaceIds;
            List<String> auditedOrganizationIds;
            switch (this.auditedOrganizationIds == null ? 0 : this.auditedOrganizationIds.size()) {
                case 0: {
                    auditedOrganizationIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    auditedOrganizationIds = Collections.singletonList(this.auditedOrganizationIds.get(0));
                    break;
                }
                default: {
                    auditedOrganizationIds = Collections.unmodifiableList(new ArrayList<String>(this.auditedOrganizationIds));
                }
            }
            switch (this.auditedSpaceIds == null ? 0 : this.auditedSpaceIds.size()) {
                case 0: {
                    auditedSpaceIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    auditedSpaceIds = Collections.singletonList(this.auditedSpaceIds.get(0));
                    break;
                }
                default: {
                    auditedSpaceIds = Collections.unmodifiableList(new ArrayList<String>(this.auditedSpaceIds));
                }
            }
            switch (this.billingManagedOrganizationIds == null ? 0 : this.billingManagedOrganizationIds.size()) {
                case 0: {
                    billingManagedOrganizationIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    billingManagedOrganizationIds = Collections.singletonList(this.billingManagedOrganizationIds.get(0));
                    break;
                }
                default: {
                    billingManagedOrganizationIds = Collections.unmodifiableList(new ArrayList<String>(this.billingManagedOrganizationIds));
                }
            }
            switch (this.managedOrganizationIds == null ? 0 : this.managedOrganizationIds.size()) {
                case 0: {
                    managedOrganizationIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    managedOrganizationIds = Collections.singletonList(this.managedOrganizationIds.get(0));
                    break;
                }
                default: {
                    managedOrganizationIds = Collections.unmodifiableList(new ArrayList<String>(this.managedOrganizationIds));
                }
            }
            switch (this.managedSpaceIds == null ? 0 : this.managedSpaceIds.size()) {
                case 0: {
                    managedSpaceIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    managedSpaceIds = Collections.singletonList(this.managedSpaceIds.get(0));
                    break;
                }
                default: {
                    managedSpaceIds = Collections.unmodifiableList(new ArrayList<String>(this.managedSpaceIds));
                }
            }
            switch (this.spaceIds == null ? 0 : this.spaceIds.size()) {
                case 0: {
                    spaceIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    spaceIds = Collections.singletonList(this.spaceIds.get(0));
                    break;
                }
                default: {
                    spaceIds = Collections.unmodifiableList(new ArrayList<String>(this.spaceIds));
                }
            }
            return new ListOrganizationManagersRequest(this.orderDirection, this.page, this.resultsPerPage, auditedOrganizationIds, auditedSpaceIds, billingManagedOrganizationIds, managedOrganizationIds, managedSpaceIds, this.organizationId, spaceIds);
        }

        public String toString() {
            return "ListOrganizationManagersRequest.ListOrganizationManagersRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", auditedOrganizationIds=" + this.auditedOrganizationIds + ", auditedSpaceIds=" + this.auditedSpaceIds + ", billingManagedOrganizationIds=" + this.billingManagedOrganizationIds + ", managedOrganizationIds=" + this.managedOrganizationIds + ", managedSpaceIds=" + this.managedSpaceIds + ", organizationId=" + this.organizationId + ", spaceIds=" + this.spaceIds + ")";
        }
    }
}

