/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListOrganizationPrivateDomainsRequest
extends PaginatedRequest
implements Validatable {
    private final List<String> names;
    private final String organizationId;

    ListOrganizationPrivateDomainsRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> names, String organizationId) {
        super(orderDirection, page, resultsPerPage);
        this.names = names;
        this.organizationId = organizationId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        return builder.build();
    }

    public static ListOrganizationPrivateDomainsRequestBuilder builder() {
        return new ListOrganizationPrivateDomainsRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListOrganizationPrivateDomainsRequest)) {
            return false;
        }
        ListOrganizationPrivateDomainsRequest other = (ListOrganizationPrivateDomainsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$names = this.getNames();
        List<String> other$names = other.getNames();
        if (this$names == null ? other$names != null : !((Object)this$names).equals(other$names)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        return !(this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListOrganizationPrivateDomainsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $names = this.getNames();
        result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListOrganizationPrivateDomainsRequest(super=" + super.toString() + ", names=" + this.getNames() + ", organizationId=" + this.getOrganizationId() + ")";
    }

    @InFilterParameter(value="name")
    public List<String> getNames() {
        return this.names;
    }

    @JsonIgnore
    public String getOrganizationId() {
        return this.organizationId;
    }

    public static class ListOrganizationPrivateDomainsRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private ArrayList<String> names;
        private String organizationId;

        ListOrganizationPrivateDomainsRequestBuilder() {
        }

        public ListOrganizationPrivateDomainsRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListOrganizationPrivateDomainsRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListOrganizationPrivateDomainsRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListOrganizationPrivateDomainsRequestBuilder name(String name) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.add(name);
            return this;
        }

        public ListOrganizationPrivateDomainsRequestBuilder names(Collection<? extends String> names) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.addAll(names);
            return this;
        }

        public ListOrganizationPrivateDomainsRequestBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public ListOrganizationPrivateDomainsRequest build() {
            List<String> names;
            switch (this.names == null ? 0 : this.names.size()) {
                case 0: {
                    names = Collections.emptyList();
                    break;
                }
                case 1: {
                    names = Collections.singletonList(this.names.get(0));
                    break;
                }
                default: {
                    names = Collections.unmodifiableList(new ArrayList<String>(this.names));
                }
            }
            return new ListOrganizationPrivateDomainsRequest(this.orderDirection, this.page, this.resultsPerPage, names, this.organizationId);
        }

        public String toString() {
            return "ListOrganizationPrivateDomainsRequest.ListOrganizationPrivateDomainsRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", names=" + this.names + ", organizationId=" + this.organizationId + ")";
        }
    }
}

