/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.v2.PaginatedResponse;
import org.cloudfoundry.client.v2.privatedomains.PrivateDomainResource;

public final class ListOrganizationPrivateDomainsResponse
extends PaginatedResponse<PrivateDomainResource> {
    ListOrganizationPrivateDomainsResponse(@JsonProperty(value="next_url") String nextUrl, @JsonProperty(value="prev_url") String previousUrl, @JsonProperty(value="resources") List<PrivateDomainResource> resources, @JsonProperty(value="total_pages") Integer totalPages, @JsonProperty(value="total_results") Integer totalResults) {
        super(nextUrl, previousUrl, resources, totalPages, totalResults);
    }

    public static ListOrganizationPrivateDomainsResponseBuilder builder() {
        return new ListOrganizationPrivateDomainsResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListOrganizationPrivateDomainsResponse)) {
            return false;
        }
        ListOrganizationPrivateDomainsResponse other = (ListOrganizationPrivateDomainsResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListOrganizationPrivateDomainsResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ListOrganizationPrivateDomainsResponse(super=" + super.toString() + ")";
    }

    public static class ListOrganizationPrivateDomainsResponseBuilder {
        private String nextUrl;
        private String previousUrl;
        private ArrayList<PrivateDomainResource> resources;
        private Integer totalPages;
        private Integer totalResults;

        ListOrganizationPrivateDomainsResponseBuilder() {
        }

        public ListOrganizationPrivateDomainsResponseBuilder nextUrl(String nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        public ListOrganizationPrivateDomainsResponseBuilder previousUrl(String previousUrl) {
            this.previousUrl = previousUrl;
            return this;
        }

        public ListOrganizationPrivateDomainsResponseBuilder resource(PrivateDomainResource resource) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
            return this;
        }

        public ListOrganizationPrivateDomainsResponseBuilder resources(Collection<? extends PrivateDomainResource> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.addAll(resources);
            return this;
        }

        public ListOrganizationPrivateDomainsResponseBuilder totalPages(Integer totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        public ListOrganizationPrivateDomainsResponseBuilder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public ListOrganizationPrivateDomainsResponse build() {
            List<PrivateDomainResource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
                case 0: {
                    resources = Collections.emptyList();
                    break;
                }
                case 1: {
                    resources = Collections.singletonList(this.resources.get(0));
                    break;
                }
                default: {
                    resources = Collections.unmodifiableList(new ArrayList<PrivateDomainResource>(this.resources));
                }
            }
            return new ListOrganizationPrivateDomainsResponse(this.nextUrl, this.previousUrl, resources, this.totalPages, this.totalResults);
        }

        public String toString() {
            return "ListOrganizationPrivateDomainsResponse.ListOrganizationPrivateDomainsResponseBuilder(nextUrl=" + this.nextUrl + ", previousUrl=" + this.previousUrl + ", resources=" + this.resources + ", totalPages=" + this.totalPages + ", totalResults=" + this.totalResults + ")";
        }
    }
}

