/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListOrganizationServicesRequest
extends PaginatedRequest
implements Validatable {
    private final List<Boolean> actives;
    private final List<String> labels;
    private final String organizationId;
    private final List<String> providers;
    private final List<String> serviceBrokerIds;

    ListOrganizationServicesRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<Boolean> actives, List<String> labels, String organizationId, List<String> providers, List<String> serviceBrokerIds) {
        super(orderDirection, page, resultsPerPage);
        this.actives = actives;
        this.labels = labels;
        this.organizationId = organizationId;
        this.providers = providers;
        this.serviceBrokerIds = serviceBrokerIds;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        return builder.build();
    }

    public static ListOrganizationServicesRequestBuilder builder() {
        return new ListOrganizationServicesRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListOrganizationServicesRequest)) {
            return false;
        }
        ListOrganizationServicesRequest other = (ListOrganizationServicesRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Boolean> this$actives = this.getActives();
        List<Boolean> other$actives = other.getActives();
        if (this$actives == null ? other$actives != null : !((Object)this$actives).equals(other$actives)) {
            return false;
        }
        List<String> this$labels = this.getLabels();
        List<String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        List<String> this$providers = this.getProviders();
        List<String> other$providers = other.getProviders();
        if (this$providers == null ? other$providers != null : !((Object)this$providers).equals(other$providers)) {
            return false;
        }
        List<String> this$serviceBrokerIds = this.getServiceBrokerIds();
        List<String> other$serviceBrokerIds = other.getServiceBrokerIds();
        return !(this$serviceBrokerIds == null ? other$serviceBrokerIds != null : !((Object)this$serviceBrokerIds).equals(other$serviceBrokerIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListOrganizationServicesRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<Boolean> $actives = this.getActives();
        result = result * 59 + ($actives == null ? 43 : ((Object)$actives).hashCode());
        List<String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        List<String> $providers = this.getProviders();
        result = result * 59 + ($providers == null ? 43 : ((Object)$providers).hashCode());
        List<String> $serviceBrokerIds = this.getServiceBrokerIds();
        result = result * 59 + ($serviceBrokerIds == null ? 43 : ((Object)$serviceBrokerIds).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListOrganizationServicesRequest(super=" + super.toString() + ", actives=" + this.getActives() + ", labels=" + this.getLabels() + ", organizationId=" + this.getOrganizationId() + ", providers=" + this.getProviders() + ", serviceBrokerIds=" + this.getServiceBrokerIds() + ")";
    }

    @InFilterParameter(value="active")
    public List<Boolean> getActives() {
        return this.actives;
    }

    @InFilterParameter(value="label")
    public List<String> getLabels() {
        return this.labels;
    }

    @JsonIgnore
    public String getOrganizationId() {
        return this.organizationId;
    }

    @InFilterParameter(value="provider")
    public List<String> getProviders() {
        return this.providers;
    }

    @InFilterParameter(value="service_broker_guid")
    public List<String> getServiceBrokerIds() {
        return this.serviceBrokerIds;
    }

    public static class ListOrganizationServicesRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private ArrayList<Boolean> actives;
        private ArrayList<String> labels;
        private String organizationId;
        private ArrayList<String> providers;
        private ArrayList<String> serviceBrokerIds;

        ListOrganizationServicesRequestBuilder() {
        }

        public ListOrganizationServicesRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListOrganizationServicesRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListOrganizationServicesRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListOrganizationServicesRequestBuilder active(Boolean active) {
            if (this.actives == null) {
                this.actives = new ArrayList();
            }
            this.actives.add(active);
            return this;
        }

        public ListOrganizationServicesRequestBuilder actives(Collection<? extends Boolean> actives) {
            if (this.actives == null) {
                this.actives = new ArrayList();
            }
            this.actives.addAll(actives);
            return this;
        }

        public ListOrganizationServicesRequestBuilder label(String label) {
            if (this.labels == null) {
                this.labels = new ArrayList();
            }
            this.labels.add(label);
            return this;
        }

        public ListOrganizationServicesRequestBuilder labels(Collection<? extends String> labels) {
            if (this.labels == null) {
                this.labels = new ArrayList();
            }
            this.labels.addAll(labels);
            return this;
        }

        public ListOrganizationServicesRequestBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public ListOrganizationServicesRequestBuilder provider(String provider) {
            if (this.providers == null) {
                this.providers = new ArrayList();
            }
            this.providers.add(provider);
            return this;
        }

        public ListOrganizationServicesRequestBuilder providers(Collection<? extends String> providers) {
            if (this.providers == null) {
                this.providers = new ArrayList();
            }
            this.providers.addAll(providers);
            return this;
        }

        public ListOrganizationServicesRequestBuilder serviceBrokerId(String serviceBrokerId) {
            if (this.serviceBrokerIds == null) {
                this.serviceBrokerIds = new ArrayList();
            }
            this.serviceBrokerIds.add(serviceBrokerId);
            return this;
        }

        public ListOrganizationServicesRequestBuilder serviceBrokerIds(Collection<? extends String> serviceBrokerIds) {
            if (this.serviceBrokerIds == null) {
                this.serviceBrokerIds = new ArrayList();
            }
            this.serviceBrokerIds.addAll(serviceBrokerIds);
            return this;
        }

        public ListOrganizationServicesRequest build() {
            List<String> serviceBrokerIds;
            List<String> providers;
            List<String> labels;
            List<Boolean> actives;
            switch (this.actives == null ? 0 : this.actives.size()) {
                case 0: {
                    actives = Collections.emptyList();
                    break;
                }
                case 1: {
                    actives = Collections.singletonList(this.actives.get(0));
                    break;
                }
                default: {
                    actives = Collections.unmodifiableList(new ArrayList<Boolean>(this.actives));
                }
            }
            switch (this.labels == null ? 0 : this.labels.size()) {
                case 0: {
                    labels = Collections.emptyList();
                    break;
                }
                case 1: {
                    labels = Collections.singletonList(this.labels.get(0));
                    break;
                }
                default: {
                    labels = Collections.unmodifiableList(new ArrayList<String>(this.labels));
                }
            }
            switch (this.providers == null ? 0 : this.providers.size()) {
                case 0: {
                    providers = Collections.emptyList();
                    break;
                }
                case 1: {
                    providers = Collections.singletonList(this.providers.get(0));
                    break;
                }
                default: {
                    providers = Collections.unmodifiableList(new ArrayList<String>(this.providers));
                }
            }
            switch (this.serviceBrokerIds == null ? 0 : this.serviceBrokerIds.size()) {
                case 0: {
                    serviceBrokerIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    serviceBrokerIds = Collections.singletonList(this.serviceBrokerIds.get(0));
                    break;
                }
                default: {
                    serviceBrokerIds = Collections.unmodifiableList(new ArrayList<String>(this.serviceBrokerIds));
                }
            }
            return new ListOrganizationServicesRequest(this.orderDirection, this.page, this.resultsPerPage, actives, labels, this.organizationId, providers, serviceBrokerIds);
        }

        public String toString() {
            return "ListOrganizationServicesRequest.ListOrganizationServicesRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", actives=" + this.actives + ", labels=" + this.labels + ", organizationId=" + this.organizationId + ", providers=" + this.providers + ", serviceBrokerIds=" + this.serviceBrokerIds + ")";
        }
    }
}

