/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.v2.PaginatedResponse;
import org.cloudfoundry.client.v2.services.ServiceResource;

public final class ListOrganizationServicesResponse
extends PaginatedResponse<ServiceResource> {
    ListOrganizationServicesResponse(@JsonProperty(value="next_url") String nextUrl, @JsonProperty(value="prev_url") String previousUrl, @JsonProperty(value="resources") List<ServiceResource> resources, @JsonProperty(value="total_pages") Integer totalPages, @JsonProperty(value="total_results") Integer totalResults) {
        super(nextUrl, previousUrl, resources, totalPages, totalResults);
    }

    public static ListOrganizationServicesResponseBuilder builder() {
        return new ListOrganizationServicesResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListOrganizationServicesResponse)) {
            return false;
        }
        ListOrganizationServicesResponse other = (ListOrganizationServicesResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListOrganizationServicesResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ListOrganizationServicesResponse(super=" + super.toString() + ")";
    }

    public static class ListOrganizationServicesResponseBuilder {
        private String nextUrl;
        private String previousUrl;
        private ArrayList<ServiceResource> resources;
        private Integer totalPages;
        private Integer totalResults;

        ListOrganizationServicesResponseBuilder() {
        }

        public ListOrganizationServicesResponseBuilder nextUrl(String nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        public ListOrganizationServicesResponseBuilder previousUrl(String previousUrl) {
            this.previousUrl = previousUrl;
            return this;
        }

        public ListOrganizationServicesResponseBuilder resource(ServiceResource resource) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
            return this;
        }

        public ListOrganizationServicesResponseBuilder resources(Collection<? extends ServiceResource> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.addAll(resources);
            return this;
        }

        public ListOrganizationServicesResponseBuilder totalPages(Integer totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        public ListOrganizationServicesResponseBuilder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public ListOrganizationServicesResponse build() {
            List<ServiceResource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
                case 0: {
                    resources = Collections.emptyList();
                    break;
                }
                case 1: {
                    resources = Collections.singletonList(this.resources.get(0));
                    break;
                }
                default: {
                    resources = Collections.unmodifiableList(new ArrayList<ServiceResource>(this.resources));
                }
            }
            return new ListOrganizationServicesResponse(this.nextUrl, this.previousUrl, resources, this.totalPages, this.totalResults);
        }

        public String toString() {
            return "ListOrganizationServicesResponse.ListOrganizationServicesResponseBuilder(nextUrl=" + this.nextUrl + ", previousUrl=" + this.previousUrl + ", resources=" + this.resources + ", totalPages=" + this.totalPages + ", totalResults=" + this.totalResults + ")";
        }
    }
}

