/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.v2.PaginatedResponse;
import org.cloudfoundry.client.v2.spacequotadefinitions.SpaceQuotaDefinitionResource;

public final class ListOrganizationSpaceQuotaDefinitionsResponse
extends PaginatedResponse<SpaceQuotaDefinitionResource> {
    ListOrganizationSpaceQuotaDefinitionsResponse(@JsonProperty(value="next_url") String nextUrl, @JsonProperty(value="prev_url") String previousUrl, @JsonProperty(value="resources") List<SpaceQuotaDefinitionResource> resources, @JsonProperty(value="total_pages") Integer totalPages, @JsonProperty(value="total_results") Integer totalResults) {
        super(nextUrl, previousUrl, resources, totalPages, totalResults);
    }

    public static ListOrganizationSpaceQuotaDefinitionsResponseBuilder builder() {
        return new ListOrganizationSpaceQuotaDefinitionsResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListOrganizationSpaceQuotaDefinitionsResponse)) {
            return false;
        }
        ListOrganizationSpaceQuotaDefinitionsResponse other = (ListOrganizationSpaceQuotaDefinitionsResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListOrganizationSpaceQuotaDefinitionsResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ListOrganizationSpaceQuotaDefinitionsResponse(super=" + super.toString() + ")";
    }

    public static class ListOrganizationSpaceQuotaDefinitionsResponseBuilder {
        private String nextUrl;
        private String previousUrl;
        private ArrayList<SpaceQuotaDefinitionResource> resources;
        private Integer totalPages;
        private Integer totalResults;

        ListOrganizationSpaceQuotaDefinitionsResponseBuilder() {
        }

        public ListOrganizationSpaceQuotaDefinitionsResponseBuilder nextUrl(String nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        public ListOrganizationSpaceQuotaDefinitionsResponseBuilder previousUrl(String previousUrl) {
            this.previousUrl = previousUrl;
            return this;
        }

        public ListOrganizationSpaceQuotaDefinitionsResponseBuilder resource(SpaceQuotaDefinitionResource resource) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
            return this;
        }

        public ListOrganizationSpaceQuotaDefinitionsResponseBuilder resources(Collection<? extends SpaceQuotaDefinitionResource> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.addAll(resources);
            return this;
        }

        public ListOrganizationSpaceQuotaDefinitionsResponseBuilder totalPages(Integer totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        public ListOrganizationSpaceQuotaDefinitionsResponseBuilder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public ListOrganizationSpaceQuotaDefinitionsResponse build() {
            List<SpaceQuotaDefinitionResource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
                case 0: {
                    resources = Collections.emptyList();
                    break;
                }
                case 1: {
                    resources = Collections.singletonList(this.resources.get(0));
                    break;
                }
                default: {
                    resources = Collections.unmodifiableList(new ArrayList<SpaceQuotaDefinitionResource>(this.resources));
                }
            }
            return new ListOrganizationSpaceQuotaDefinitionsResponse(this.nextUrl, this.previousUrl, resources, this.totalPages, this.totalResults);
        }

        public String toString() {
            return "ListOrganizationSpaceQuotaDefinitionsResponse.ListOrganizationSpaceQuotaDefinitionsResponseBuilder(nextUrl=" + this.nextUrl + ", previousUrl=" + this.previousUrl + ", resources=" + this.resources + ", totalPages=" + this.totalPages + ", totalResults=" + this.totalResults + ")";
        }
    }
}

