/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListOrganizationSpacesRequest
extends PaginatedRequest
implements Validatable {
    private final List<String> appIds;
    private final List<String> developerIds;
    private final List<String> names;
    private final String organizationId;

    ListOrganizationSpacesRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> appIds, List<String> developerIds, List<String> names, String organizationId) {
        super(orderDirection, page, resultsPerPage);
        this.appIds = appIds;
        this.developerIds = developerIds;
        this.names = names;
        this.organizationId = organizationId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        return builder.build();
    }

    public static ListOrganizationSpacesRequestBuilder builder() {
        return new ListOrganizationSpacesRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListOrganizationSpacesRequest)) {
            return false;
        }
        ListOrganizationSpacesRequest other = (ListOrganizationSpacesRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$appIds = this.getAppIds();
        List<String> other$appIds = other.getAppIds();
        if (this$appIds == null ? other$appIds != null : !((Object)this$appIds).equals(other$appIds)) {
            return false;
        }
        List<String> this$developerIds = this.getDeveloperIds();
        List<String> other$developerIds = other.getDeveloperIds();
        if (this$developerIds == null ? other$developerIds != null : !((Object)this$developerIds).equals(other$developerIds)) {
            return false;
        }
        List<String> this$names = this.getNames();
        List<String> other$names = other.getNames();
        if (this$names == null ? other$names != null : !((Object)this$names).equals(other$names)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        return !(this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListOrganizationSpacesRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $appIds = this.getAppIds();
        result = result * 59 + ($appIds == null ? 43 : ((Object)$appIds).hashCode());
        List<String> $developerIds = this.getDeveloperIds();
        result = result * 59 + ($developerIds == null ? 43 : ((Object)$developerIds).hashCode());
        List<String> $names = this.getNames();
        result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListOrganizationSpacesRequest(super=" + super.toString() + ", appIds=" + this.getAppIds() + ", developerIds=" + this.getDeveloperIds() + ", names=" + this.getNames() + ", organizationId=" + this.getOrganizationId() + ")";
    }

    @InFilterParameter(value="app_guid")
    public List<String> getAppIds() {
        return this.appIds;
    }

    @InFilterParameter(value="developer_guid")
    public List<String> getDeveloperIds() {
        return this.developerIds;
    }

    @InFilterParameter(value="name")
    public List<String> getNames() {
        return this.names;
    }

    @JsonIgnore
    public String getOrganizationId() {
        return this.organizationId;
    }

    public static class ListOrganizationSpacesRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private ArrayList<String> appIds;
        private ArrayList<String> developerIds;
        private ArrayList<String> names;
        private String organizationId;

        ListOrganizationSpacesRequestBuilder() {
        }

        public ListOrganizationSpacesRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListOrganizationSpacesRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListOrganizationSpacesRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListOrganizationSpacesRequestBuilder appId(String appId) {
            if (this.appIds == null) {
                this.appIds = new ArrayList();
            }
            this.appIds.add(appId);
            return this;
        }

        public ListOrganizationSpacesRequestBuilder appIds(Collection<? extends String> appIds) {
            if (this.appIds == null) {
                this.appIds = new ArrayList();
            }
            this.appIds.addAll(appIds);
            return this;
        }

        public ListOrganizationSpacesRequestBuilder developerId(String developerId) {
            if (this.developerIds == null) {
                this.developerIds = new ArrayList();
            }
            this.developerIds.add(developerId);
            return this;
        }

        public ListOrganizationSpacesRequestBuilder developerIds(Collection<? extends String> developerIds) {
            if (this.developerIds == null) {
                this.developerIds = new ArrayList();
            }
            this.developerIds.addAll(developerIds);
            return this;
        }

        public ListOrganizationSpacesRequestBuilder name(String name) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.add(name);
            return this;
        }

        public ListOrganizationSpacesRequestBuilder names(Collection<? extends String> names) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.addAll(names);
            return this;
        }

        public ListOrganizationSpacesRequestBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public ListOrganizationSpacesRequest build() {
            List<String> names;
            List<String> developerIds;
            List<String> appIds;
            switch (this.appIds == null ? 0 : this.appIds.size()) {
                case 0: {
                    appIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    appIds = Collections.singletonList(this.appIds.get(0));
                    break;
                }
                default: {
                    appIds = Collections.unmodifiableList(new ArrayList<String>(this.appIds));
                }
            }
            switch (this.developerIds == null ? 0 : this.developerIds.size()) {
                case 0: {
                    developerIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    developerIds = Collections.singletonList(this.developerIds.get(0));
                    break;
                }
                default: {
                    developerIds = Collections.unmodifiableList(new ArrayList<String>(this.developerIds));
                }
            }
            switch (this.names == null ? 0 : this.names.size()) {
                case 0: {
                    names = Collections.emptyList();
                    break;
                }
                case 1: {
                    names = Collections.singletonList(this.names.get(0));
                    break;
                }
                default: {
                    names = Collections.unmodifiableList(new ArrayList<String>(this.names));
                }
            }
            return new ListOrganizationSpacesRequest(this.orderDirection, this.page, this.resultsPerPage, appIds, developerIds, names, this.organizationId);
        }

        public String toString() {
            return "ListOrganizationSpacesRequest.ListOrganizationSpacesRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", appIds=" + this.appIds + ", developerIds=" + this.developerIds + ", names=" + this.names + ", organizationId=" + this.organizationId + ")";
        }
    }
}

