/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListOrganizationsRequest
extends PaginatedRequest
implements Validatable {
    private final List<String> auditorIds;
    private final List<String> billingManagerIds;
    private final List<String> managerIds;
    private final List<String> names;
    private final List<String> spaceIds;
    private final List<String> statuses;
    private final List<String> userIds;

    ListOrganizationsRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> auditorIds, List<String> billingManagerIds, List<String> managerIds, List<String> names, List<String> spaceIds, List<String> statuses, List<String> userIds) {
        super(orderDirection, page, resultsPerPage);
        this.auditorIds = auditorIds;
        this.billingManagerIds = billingManagerIds;
        this.managerIds = managerIds;
        this.names = names;
        this.spaceIds = spaceIds;
        this.statuses = statuses;
        this.userIds = userIds;
    }

    @Override
    public ValidationResult isValid() {
        return ValidationResult.builder().build();
    }

    public static ListOrganizationsRequestBuilder builder() {
        return new ListOrganizationsRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListOrganizationsRequest)) {
            return false;
        }
        ListOrganizationsRequest other = (ListOrganizationsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$auditorIds = this.getAuditorIds();
        List<String> other$auditorIds = other.getAuditorIds();
        if (this$auditorIds == null ? other$auditorIds != null : !((Object)this$auditorIds).equals(other$auditorIds)) {
            return false;
        }
        List<String> this$billingManagerIds = this.getBillingManagerIds();
        List<String> other$billingManagerIds = other.getBillingManagerIds();
        if (this$billingManagerIds == null ? other$billingManagerIds != null : !((Object)this$billingManagerIds).equals(other$billingManagerIds)) {
            return false;
        }
        List<String> this$managerIds = this.getManagerIds();
        List<String> other$managerIds = other.getManagerIds();
        if (this$managerIds == null ? other$managerIds != null : !((Object)this$managerIds).equals(other$managerIds)) {
            return false;
        }
        List<String> this$names = this.getNames();
        List<String> other$names = other.getNames();
        if (this$names == null ? other$names != null : !((Object)this$names).equals(other$names)) {
            return false;
        }
        List<String> this$spaceIds = this.getSpaceIds();
        List<String> other$spaceIds = other.getSpaceIds();
        if (this$spaceIds == null ? other$spaceIds != null : !((Object)this$spaceIds).equals(other$spaceIds)) {
            return false;
        }
        List<String> this$statuses = this.getStatuses();
        List<String> other$statuses = other.getStatuses();
        if (this$statuses == null ? other$statuses != null : !((Object)this$statuses).equals(other$statuses)) {
            return false;
        }
        List<String> this$userIds = this.getUserIds();
        List<String> other$userIds = other.getUserIds();
        return !(this$userIds == null ? other$userIds != null : !((Object)this$userIds).equals(other$userIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListOrganizationsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $auditorIds = this.getAuditorIds();
        result = result * 59 + ($auditorIds == null ? 43 : ((Object)$auditorIds).hashCode());
        List<String> $billingManagerIds = this.getBillingManagerIds();
        result = result * 59 + ($billingManagerIds == null ? 43 : ((Object)$billingManagerIds).hashCode());
        List<String> $managerIds = this.getManagerIds();
        result = result * 59 + ($managerIds == null ? 43 : ((Object)$managerIds).hashCode());
        List<String> $names = this.getNames();
        result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
        List<String> $spaceIds = this.getSpaceIds();
        result = result * 59 + ($spaceIds == null ? 43 : ((Object)$spaceIds).hashCode());
        List<String> $statuses = this.getStatuses();
        result = result * 59 + ($statuses == null ? 43 : ((Object)$statuses).hashCode());
        List<String> $userIds = this.getUserIds();
        result = result * 59 + ($userIds == null ? 43 : ((Object)$userIds).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListOrganizationsRequest(super=" + super.toString() + ", auditorIds=" + this.getAuditorIds() + ", billingManagerIds=" + this.getBillingManagerIds() + ", managerIds=" + this.getManagerIds() + ", names=" + this.getNames() + ", spaceIds=" + this.getSpaceIds() + ", statuses=" + this.getStatuses() + ", userIds=" + this.getUserIds() + ")";
    }

    @InFilterParameter(value="auditor_guid")
    public List<String> getAuditorIds() {
        return this.auditorIds;
    }

    @InFilterParameter(value="billing_manager_guid")
    public List<String> getBillingManagerIds() {
        return this.billingManagerIds;
    }

    @InFilterParameter(value="manager_guid")
    public List<String> getManagerIds() {
        return this.managerIds;
    }

    @InFilterParameter(value="name")
    public List<String> getNames() {
        return this.names;
    }

    @InFilterParameter(value="space_guid")
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }

    @InFilterParameter(value="status")
    public List<String> getStatuses() {
        return this.statuses;
    }

    @InFilterParameter(value="user_guid")
    public List<String> getUserIds() {
        return this.userIds;
    }

    public static class ListOrganizationsRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private ArrayList<String> auditorIds;
        private ArrayList<String> billingManagerIds;
        private ArrayList<String> managerIds;
        private ArrayList<String> names;
        private ArrayList<String> spaceIds;
        private ArrayList<String> statuses;
        private ArrayList<String> userIds;

        ListOrganizationsRequestBuilder() {
        }

        public ListOrganizationsRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListOrganizationsRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListOrganizationsRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListOrganizationsRequestBuilder auditorId(String auditorId) {
            if (this.auditorIds == null) {
                this.auditorIds = new ArrayList();
            }
            this.auditorIds.add(auditorId);
            return this;
        }

        public ListOrganizationsRequestBuilder auditorIds(Collection<? extends String> auditorIds) {
            if (this.auditorIds == null) {
                this.auditorIds = new ArrayList();
            }
            this.auditorIds.addAll(auditorIds);
            return this;
        }

        public ListOrganizationsRequestBuilder billingManagerId(String billingManagerId) {
            if (this.billingManagerIds == null) {
                this.billingManagerIds = new ArrayList();
            }
            this.billingManagerIds.add(billingManagerId);
            return this;
        }

        public ListOrganizationsRequestBuilder billingManagerIds(Collection<? extends String> billingManagerIds) {
            if (this.billingManagerIds == null) {
                this.billingManagerIds = new ArrayList();
            }
            this.billingManagerIds.addAll(billingManagerIds);
            return this;
        }

        public ListOrganizationsRequestBuilder managerId(String managerId) {
            if (this.managerIds == null) {
                this.managerIds = new ArrayList();
            }
            this.managerIds.add(managerId);
            return this;
        }

        public ListOrganizationsRequestBuilder managerIds(Collection<? extends String> managerIds) {
            if (this.managerIds == null) {
                this.managerIds = new ArrayList();
            }
            this.managerIds.addAll(managerIds);
            return this;
        }

        public ListOrganizationsRequestBuilder name(String name) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.add(name);
            return this;
        }

        public ListOrganizationsRequestBuilder names(Collection<? extends String> names) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.addAll(names);
            return this;
        }

        public ListOrganizationsRequestBuilder spaceId(String spaceId) {
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList();
            }
            this.spaceIds.add(spaceId);
            return this;
        }

        public ListOrganizationsRequestBuilder spaceIds(Collection<? extends String> spaceIds) {
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList();
            }
            this.spaceIds.addAll(spaceIds);
            return this;
        }

        public ListOrganizationsRequestBuilder status(String status) {
            if (this.statuses == null) {
                this.statuses = new ArrayList();
            }
            this.statuses.add(status);
            return this;
        }

        public ListOrganizationsRequestBuilder statuses(Collection<? extends String> statuses) {
            if (this.statuses == null) {
                this.statuses = new ArrayList();
            }
            this.statuses.addAll(statuses);
            return this;
        }

        public ListOrganizationsRequestBuilder userId(String userId) {
            if (this.userIds == null) {
                this.userIds = new ArrayList();
            }
            this.userIds.add(userId);
            return this;
        }

        public ListOrganizationsRequestBuilder userIds(Collection<? extends String> userIds) {
            if (this.userIds == null) {
                this.userIds = new ArrayList();
            }
            this.userIds.addAll(userIds);
            return this;
        }

        public ListOrganizationsRequest build() {
            List<String> userIds;
            List<String> statuses;
            List<String> spaceIds;
            List<String> names;
            List<String> managerIds;
            List<String> billingManagerIds;
            List<String> auditorIds;
            switch (this.auditorIds == null ? 0 : this.auditorIds.size()) {
                case 0: {
                    auditorIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    auditorIds = Collections.singletonList(this.auditorIds.get(0));
                    break;
                }
                default: {
                    auditorIds = Collections.unmodifiableList(new ArrayList<String>(this.auditorIds));
                }
            }
            switch (this.billingManagerIds == null ? 0 : this.billingManagerIds.size()) {
                case 0: {
                    billingManagerIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    billingManagerIds = Collections.singletonList(this.billingManagerIds.get(0));
                    break;
                }
                default: {
                    billingManagerIds = Collections.unmodifiableList(new ArrayList<String>(this.billingManagerIds));
                }
            }
            switch (this.managerIds == null ? 0 : this.managerIds.size()) {
                case 0: {
                    managerIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    managerIds = Collections.singletonList(this.managerIds.get(0));
                    break;
                }
                default: {
                    managerIds = Collections.unmodifiableList(new ArrayList<String>(this.managerIds));
                }
            }
            switch (this.names == null ? 0 : this.names.size()) {
                case 0: {
                    names = Collections.emptyList();
                    break;
                }
                case 1: {
                    names = Collections.singletonList(this.names.get(0));
                    break;
                }
                default: {
                    names = Collections.unmodifiableList(new ArrayList<String>(this.names));
                }
            }
            switch (this.spaceIds == null ? 0 : this.spaceIds.size()) {
                case 0: {
                    spaceIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    spaceIds = Collections.singletonList(this.spaceIds.get(0));
                    break;
                }
                default: {
                    spaceIds = Collections.unmodifiableList(new ArrayList<String>(this.spaceIds));
                }
            }
            switch (this.statuses == null ? 0 : this.statuses.size()) {
                case 0: {
                    statuses = Collections.emptyList();
                    break;
                }
                case 1: {
                    statuses = Collections.singletonList(this.statuses.get(0));
                    break;
                }
                default: {
                    statuses = Collections.unmodifiableList(new ArrayList<String>(this.statuses));
                }
            }
            switch (this.userIds == null ? 0 : this.userIds.size()) {
                case 0: {
                    userIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    userIds = Collections.singletonList(this.userIds.get(0));
                    break;
                }
                default: {
                    userIds = Collections.unmodifiableList(new ArrayList<String>(this.userIds));
                }
            }
            return new ListOrganizationsRequest(this.orderDirection, this.page, this.resultsPerPage, auditorIds, billingManagerIds, managerIds, names, spaceIds, statuses, userIds);
        }

        public String toString() {
            return "ListOrganizationsRequest.ListOrganizationsRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", auditorIds=" + this.auditorIds + ", billingManagerIds=" + this.billingManagerIds + ", managerIds=" + this.managerIds + ", names=" + this.names + ", spaceIds=" + this.spaceIds + ", statuses=" + this.statuses + ", userIds=" + this.userIds + ")";
        }
    }
}

