/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.v2.PaginatedResponse;
import org.cloudfoundry.client.v2.organizations.OrganizationResource;

public final class ListOrganizationsResponse
extends PaginatedResponse<OrganizationResource> {
    ListOrganizationsResponse(@JsonProperty(value="next_url") String nextUrl, @JsonProperty(value="prev_url") String previousUrl, @JsonProperty(value="resources") List<OrganizationResource> resources, @JsonProperty(value="total_pages") Integer totalPages, @JsonProperty(value="total_results") Integer totalResults) {
        super(nextUrl, previousUrl, resources, totalPages, totalResults);
    }

    public static ListOrganizationsResponseBuilder builder() {
        return new ListOrganizationsResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListOrganizationsResponse)) {
            return false;
        }
        ListOrganizationsResponse other = (ListOrganizationsResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListOrganizationsResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ListOrganizationsResponse(super=" + super.toString() + ")";
    }

    public static class ListOrganizationsResponseBuilder {
        private String nextUrl;
        private String previousUrl;
        private ArrayList<OrganizationResource> resources;
        private Integer totalPages;
        private Integer totalResults;

        ListOrganizationsResponseBuilder() {
        }

        public ListOrganizationsResponseBuilder nextUrl(String nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        public ListOrganizationsResponseBuilder previousUrl(String previousUrl) {
            this.previousUrl = previousUrl;
            return this;
        }

        public ListOrganizationsResponseBuilder resource(OrganizationResource resource) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
            return this;
        }

        public ListOrganizationsResponseBuilder resources(Collection<? extends OrganizationResource> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.addAll(resources);
            return this;
        }

        public ListOrganizationsResponseBuilder totalPages(Integer totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        public ListOrganizationsResponseBuilder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public ListOrganizationsResponse build() {
            List<OrganizationResource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
                case 0: {
                    resources = Collections.emptyList();
                    break;
                }
                case 1: {
                    resources = Collections.singletonList(this.resources.get(0));
                    break;
                }
                default: {
                    resources = Collections.unmodifiableList(new ArrayList<OrganizationResource>(this.resources));
                }
            }
            return new ListOrganizationsResponse(this.nextUrl, this.previousUrl, resources, this.totalPages, this.totalResults);
        }

        public String toString() {
            return "ListOrganizationsResponse.ListOrganizationsResponseBuilder(nextUrl=" + this.nextUrl + ", previousUrl=" + this.previousUrl + ", resources=" + this.resources + ", totalPages=" + this.totalPages + ", totalResults=" + this.totalResults + ")";
        }
    }
}

