/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class RemoveOrganizationAuditorRequest
implements Validatable {
    private final String auditorId;
    private final String organizationId;

    RemoveOrganizationAuditorRequest(String auditorId, String organizationId) {
        this.auditorId = auditorId;
        this.organizationId = organizationId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.auditorId == null) {
            builder.message("auditor id must be specified");
        }
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        return builder.build();
    }

    public static RemoveOrganizationAuditorRequestBuilder builder() {
        return new RemoveOrganizationAuditorRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveOrganizationAuditorRequest)) {
            return false;
        }
        RemoveOrganizationAuditorRequest other = (RemoveOrganizationAuditorRequest)o;
        String this$auditorId = this.getAuditorId();
        String other$auditorId = other.getAuditorId();
        if (this$auditorId == null ? other$auditorId != null : !this$auditorId.equals(other$auditorId)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        return !(this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $auditorId = this.getAuditorId();
        result = result * 59 + ($auditorId == null ? 43 : $auditorId.hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        return result;
    }

    public String toString() {
        return "RemoveOrganizationAuditorRequest(auditorId=" + this.getAuditorId() + ", organizationId=" + this.getOrganizationId() + ")";
    }

    @JsonIgnore
    public String getAuditorId() {
        return this.auditorId;
    }

    @JsonIgnore
    public String getOrganizationId() {
        return this.organizationId;
    }

    public static class RemoveOrganizationAuditorRequestBuilder {
        private String auditorId;
        private String organizationId;

        RemoveOrganizationAuditorRequestBuilder() {
        }

        public RemoveOrganizationAuditorRequestBuilder auditorId(String auditorId) {
            this.auditorId = auditorId;
            return this;
        }

        public RemoveOrganizationAuditorRequestBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public RemoveOrganizationAuditorRequest build() {
            return new RemoveOrganizationAuditorRequest(this.auditorId, this.organizationId);
        }

        public String toString() {
            return "RemoveOrganizationAuditorRequest.RemoveOrganizationAuditorRequestBuilder(auditorId=" + this.auditorId + ", organizationId=" + this.organizationId + ")";
        }
    }
}

