/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class RemoveOrganizationBillingManagerRequest
implements Validatable {
    private final String billingManagerId;
    private final String organizationId;

    RemoveOrganizationBillingManagerRequest(String billingManagerId, String organizationId) {
        this.billingManagerId = billingManagerId;
        this.organizationId = organizationId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.billingManagerId == null) {
            builder.message("billing manager id must be specified");
        }
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        return builder.build();
    }

    public static RemoveOrganizationBillingManagerRequestBuilder builder() {
        return new RemoveOrganizationBillingManagerRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveOrganizationBillingManagerRequest)) {
            return false;
        }
        RemoveOrganizationBillingManagerRequest other = (RemoveOrganizationBillingManagerRequest)o;
        String this$billingManagerId = this.getBillingManagerId();
        String other$billingManagerId = other.getBillingManagerId();
        if (this$billingManagerId == null ? other$billingManagerId != null : !this$billingManagerId.equals(other$billingManagerId)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        return !(this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $billingManagerId = this.getBillingManagerId();
        result = result * 59 + ($billingManagerId == null ? 43 : $billingManagerId.hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        return result;
    }

    public String toString() {
        return "RemoveOrganizationBillingManagerRequest(billingManagerId=" + this.getBillingManagerId() + ", organizationId=" + this.getOrganizationId() + ")";
    }

    @JsonIgnore
    public String getBillingManagerId() {
        return this.billingManagerId;
    }

    @JsonIgnore
    public String getOrganizationId() {
        return this.organizationId;
    }

    public static class RemoveOrganizationBillingManagerRequestBuilder {
        private String billingManagerId;
        private String organizationId;

        RemoveOrganizationBillingManagerRequestBuilder() {
        }

        public RemoveOrganizationBillingManagerRequestBuilder billingManagerId(String billingManagerId) {
            this.billingManagerId = billingManagerId;
            return this;
        }

        public RemoveOrganizationBillingManagerRequestBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public RemoveOrganizationBillingManagerRequest build() {
            return new RemoveOrganizationBillingManagerRequest(this.billingManagerId, this.organizationId);
        }

        public String toString() {
            return "RemoveOrganizationBillingManagerRequest.RemoveOrganizationBillingManagerRequestBuilder(billingManagerId=" + this.billingManagerId + ", organizationId=" + this.organizationId + ")";
        }
    }
}

