/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class RemoveOrganizationManagerRequest
implements Validatable {
    private final String managerId;
    private final String organizationId;

    RemoveOrganizationManagerRequest(String managerId, String organizationId) {
        this.managerId = managerId;
        this.organizationId = organizationId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.managerId == null) {
            builder.message("manager id must be specified");
        }
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        return builder.build();
    }

    public static RemoveOrganizationManagerRequestBuilder builder() {
        return new RemoveOrganizationManagerRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveOrganizationManagerRequest)) {
            return false;
        }
        RemoveOrganizationManagerRequest other = (RemoveOrganizationManagerRequest)o;
        String this$managerId = this.getManagerId();
        String other$managerId = other.getManagerId();
        if (this$managerId == null ? other$managerId != null : !this$managerId.equals(other$managerId)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        return !(this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $managerId = this.getManagerId();
        result = result * 59 + ($managerId == null ? 43 : $managerId.hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        return result;
    }

    public String toString() {
        return "RemoveOrganizationManagerRequest(managerId=" + this.getManagerId() + ", organizationId=" + this.getOrganizationId() + ")";
    }

    @JsonIgnore
    public String getManagerId() {
        return this.managerId;
    }

    @JsonIgnore
    public String getOrganizationId() {
        return this.organizationId;
    }

    public static class RemoveOrganizationManagerRequestBuilder {
        private String managerId;
        private String organizationId;

        RemoveOrganizationManagerRequestBuilder() {
        }

        public RemoveOrganizationManagerRequestBuilder managerId(String managerId) {
            this.managerId = managerId;
            return this;
        }

        public RemoveOrganizationManagerRequestBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public RemoveOrganizationManagerRequest build() {
            return new RemoveOrganizationManagerRequest(this.managerId, this.organizationId);
        }

        public String toString() {
            return "RemoveOrganizationManagerRequest.RemoveOrganizationManagerRequestBuilder(managerId=" + this.managerId + ", organizationId=" + this.organizationId + ")";
        }
    }
}

