/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class RemoveOrganizationPrivateDomainRequest
implements Validatable {
    private final String organizationId;
    private final String privateDomainId;

    RemoveOrganizationPrivateDomainRequest(String organizationId, String privateDomainId) {
        this.organizationId = organizationId;
        this.privateDomainId = privateDomainId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        if (this.privateDomainId == null) {
            builder.message("private domain id must be specified");
        }
        return builder.build();
    }

    public static RemoveOrganizationPrivateDomainRequestBuilder builder() {
        return new RemoveOrganizationPrivateDomainRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveOrganizationPrivateDomainRequest)) {
            return false;
        }
        RemoveOrganizationPrivateDomainRequest other = (RemoveOrganizationPrivateDomainRequest)o;
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        String this$privateDomainId = this.getPrivateDomainId();
        String other$privateDomainId = other.getPrivateDomainId();
        return !(this$privateDomainId == null ? other$privateDomainId != null : !this$privateDomainId.equals(other$privateDomainId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        String $privateDomainId = this.getPrivateDomainId();
        result = result * 59 + ($privateDomainId == null ? 43 : $privateDomainId.hashCode());
        return result;
    }

    public String toString() {
        return "RemoveOrganizationPrivateDomainRequest(organizationId=" + this.getOrganizationId() + ", privateDomainId=" + this.getPrivateDomainId() + ")";
    }

    @JsonIgnore
    public String getOrganizationId() {
        return this.organizationId;
    }

    @JsonIgnore
    public String getPrivateDomainId() {
        return this.privateDomainId;
    }

    public static class RemoveOrganizationPrivateDomainRequestBuilder {
        private String organizationId;
        private String privateDomainId;

        RemoveOrganizationPrivateDomainRequestBuilder() {
        }

        public RemoveOrganizationPrivateDomainRequestBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public RemoveOrganizationPrivateDomainRequestBuilder privateDomainId(String privateDomainId) {
            this.privateDomainId = privateDomainId;
            return this;
        }

        public RemoveOrganizationPrivateDomainRequest build() {
            return new RemoveOrganizationPrivateDomainRequest(this.organizationId, this.privateDomainId);
        }

        public String toString() {
            return "RemoveOrganizationPrivateDomainRequest.RemoveOrganizationPrivateDomainRequestBuilder(organizationId=" + this.organizationId + ", privateDomainId=" + this.privateDomainId + ")";
        }
    }
}

