/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.v2.organizations.OrganizationSpaceSummary;

public final class SummaryOrganizationResponse {
    private final String id;
    private final String name;
    private final List<OrganizationSpaceSummary> spaces;
    private final String status;

    SummaryOrganizationResponse(@JsonProperty(value="guid") String id, @JsonProperty(value="name") String name, @JsonProperty(value="spaces") List<OrganizationSpaceSummary> spaces, @JsonProperty(value="status") String status) {
        this.id = id;
        this.name = name;
        this.spaces = spaces;
        this.status = status;
    }

    public static SummaryOrganizationResponseBuilder builder() {
        return new SummaryOrganizationResponseBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<OrganizationSpaceSummary> getSpaces() {
        return this.spaces;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SummaryOrganizationResponse)) {
            return false;
        }
        SummaryOrganizationResponse other = (SummaryOrganizationResponse)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<OrganizationSpaceSummary> this$spaces = this.getSpaces();
        List<OrganizationSpaceSummary> other$spaces = other.getSpaces();
        if (this$spaces == null ? other$spaces != null : !((Object)this$spaces).equals(other$spaces)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<OrganizationSpaceSummary> $spaces = this.getSpaces();
        result = result * 59 + ($spaces == null ? 43 : ((Object)$spaces).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    public String toString() {
        return "SummaryOrganizationResponse(id=" + this.getId() + ", name=" + this.getName() + ", spaces=" + this.getSpaces() + ", status=" + this.getStatus() + ")";
    }

    public static class SummaryOrganizationResponseBuilder {
        private String id;
        private String name;
        private ArrayList<OrganizationSpaceSummary> spaces;
        private String status;

        SummaryOrganizationResponseBuilder() {
        }

        public SummaryOrganizationResponseBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SummaryOrganizationResponseBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SummaryOrganizationResponseBuilder space(OrganizationSpaceSummary space) {
            if (this.spaces == null) {
                this.spaces = new ArrayList();
            }
            this.spaces.add(space);
            return this;
        }

        public SummaryOrganizationResponseBuilder spaces(Collection<? extends OrganizationSpaceSummary> spaces) {
            if (this.spaces == null) {
                this.spaces = new ArrayList();
            }
            this.spaces.addAll(spaces);
            return this;
        }

        public SummaryOrganizationResponseBuilder status(String status) {
            this.status = status;
            return this;
        }

        public SummaryOrganizationResponse build() {
            List<OrganizationSpaceSummary> spaces;
            switch (this.spaces == null ? 0 : this.spaces.size()) {
                case 0: {
                    spaces = Collections.emptyList();
                    break;
                }
                case 1: {
                    spaces = Collections.singletonList(this.spaces.get(0));
                    break;
                }
                default: {
                    spaces = Collections.unmodifiableList(new ArrayList<OrganizationSpaceSummary>(this.spaces));
                }
            }
            return new SummaryOrganizationResponse(this.id, this.name, spaces, this.status);
        }

        public String toString() {
            return "SummaryOrganizationResponse.SummaryOrganizationResponseBuilder(id=" + this.id + ", name=" + this.name + ", spaces=" + this.spaces + ", status=" + this.status + ")";
        }
    }
}

