/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class UpdateOrganizationRequest
implements Validatable {
    private final String name;
    private final String organizationId;
    private final String quotaDefinitionId;
    private final String status;

    UpdateOrganizationRequest(String name, String organizationId, String quotaDefinitionId, String status) {
        this.name = name;
        this.organizationId = organizationId;
        this.quotaDefinitionId = quotaDefinitionId;
        this.status = status;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        return builder.build();
    }

    public static UpdateOrganizationRequestBuilder builder() {
        return new UpdateOrganizationRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateOrganizationRequest)) {
            return false;
        }
        UpdateOrganizationRequest other = (UpdateOrganizationRequest)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        String this$quotaDefinitionId = this.getQuotaDefinitionId();
        String other$quotaDefinitionId = other.getQuotaDefinitionId();
        if (this$quotaDefinitionId == null ? other$quotaDefinitionId != null : !this$quotaDefinitionId.equals(other$quotaDefinitionId)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        String $quotaDefinitionId = this.getQuotaDefinitionId();
        result = result * 59 + ($quotaDefinitionId == null ? 43 : $quotaDefinitionId.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    public String toString() {
        return "UpdateOrganizationRequest(name=" + this.getName() + ", organizationId=" + this.getOrganizationId() + ", quotaDefinitionId=" + this.getQuotaDefinitionId() + ", status=" + this.getStatus() + ")";
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public String getOrganizationId() {
        return this.organizationId;
    }

    @JsonProperty(value="quota_definition_guid")
    public String getQuotaDefinitionId() {
        return this.quotaDefinitionId;
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    public static class UpdateOrganizationRequestBuilder {
        private String name;
        private String organizationId;
        private String quotaDefinitionId;
        private String status;

        UpdateOrganizationRequestBuilder() {
        }

        public UpdateOrganizationRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public UpdateOrganizationRequestBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public UpdateOrganizationRequestBuilder quotaDefinitionId(String quotaDefinitionId) {
            this.quotaDefinitionId = quotaDefinitionId;
            return this;
        }

        public UpdateOrganizationRequestBuilder status(String status) {
            this.status = status;
            return this;
        }

        public UpdateOrganizationRequest build() {
            return new UpdateOrganizationRequest(this.name, this.organizationId, this.quotaDefinitionId, this.status);
        }

        public String toString() {
            return "UpdateOrganizationRequest.UpdateOrganizationRequestBuilder(name=" + this.name + ", organizationId=" + this.organizationId + ", quotaDefinitionId=" + this.quotaDefinitionId + ", status=" + this.status + ")";
        }
    }
}

