/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.cloudfoundry.client.v2.users.AbstractUserEntity;

public final class UserOrganizationRoleEntity
extends AbstractUserEntity {
    private final List<String> organizationRoles;

    UserOrganizationRoleEntity(@JsonProperty(value="active") Boolean active, @JsonProperty(value="admin") Boolean admin, @JsonProperty(value="audited_organizations_url") String auditedOrganizationsUrl, @JsonProperty(value="audited_spaces_url") String auditedSpacesUrl, @JsonProperty(value="billing_managed_organizations_url") String billingManagedOrganizationsUrl, @JsonProperty(value="default_space_guid") String defaultSpaceId, @JsonProperty(value="default_space_url") String defaultSpaceUrl, @JsonProperty(value="managed_organizations_url") String managedOrganizationsUrl, @JsonProperty(value="managed_spaces_url") String managedSpacesUrl, @JsonProperty(value="organizations_url") String organizationsUrl, @JsonProperty(value="organization_roles") List<String> organizationRoles, @JsonProperty(value="spaces_url") String spacesUrl, @JsonProperty(value="username") String username) {
        super(active, admin, auditedOrganizationsUrl, auditedSpacesUrl, billingManagedOrganizationsUrl, defaultSpaceId, defaultSpaceUrl, managedOrganizationsUrl, managedSpacesUrl, organizationsUrl, spacesUrl, username);
        this.organizationRoles = Optional.ofNullable(organizationRoles).orElse(Collections.emptyList());
    }

    public static UserOrganizationRoleEntityBuilder builder() {
        return new UserOrganizationRoleEntityBuilder();
    }

    public List<String> getOrganizationRoles() {
        return this.organizationRoles;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserOrganizationRoleEntity)) {
            return false;
        }
        UserOrganizationRoleEntity other = (UserOrganizationRoleEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$organizationRoles = this.getOrganizationRoles();
        List<String> other$organizationRoles = other.getOrganizationRoles();
        return !(this$organizationRoles == null ? other$organizationRoles != null : !((Object)this$organizationRoles).equals(other$organizationRoles));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UserOrganizationRoleEntity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $organizationRoles = this.getOrganizationRoles();
        result = result * 59 + ($organizationRoles == null ? 43 : ((Object)$organizationRoles).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "UserOrganizationRoleEntity(super=" + super.toString() + ", organizationRoles=" + this.getOrganizationRoles() + ")";
    }

    public static class UserOrganizationRoleEntityBuilder {
        private Boolean active;
        private Boolean admin;
        private String auditedOrganizationsUrl;
        private String auditedSpacesUrl;
        private String billingManagedOrganizationsUrl;
        private String defaultSpaceId;
        private String defaultSpaceUrl;
        private String managedOrganizationsUrl;
        private String managedSpacesUrl;
        private String organizationsUrl;
        private ArrayList<String> organizationRoles;
        private String spacesUrl;
        private String username;

        UserOrganizationRoleEntityBuilder() {
        }

        public UserOrganizationRoleEntityBuilder active(Boolean active) {
            this.active = active;
            return this;
        }

        public UserOrganizationRoleEntityBuilder admin(Boolean admin) {
            this.admin = admin;
            return this;
        }

        public UserOrganizationRoleEntityBuilder auditedOrganizationsUrl(String auditedOrganizationsUrl) {
            this.auditedOrganizationsUrl = auditedOrganizationsUrl;
            return this;
        }

        public UserOrganizationRoleEntityBuilder auditedSpacesUrl(String auditedSpacesUrl) {
            this.auditedSpacesUrl = auditedSpacesUrl;
            return this;
        }

        public UserOrganizationRoleEntityBuilder billingManagedOrganizationsUrl(String billingManagedOrganizationsUrl) {
            this.billingManagedOrganizationsUrl = billingManagedOrganizationsUrl;
            return this;
        }

        public UserOrganizationRoleEntityBuilder defaultSpaceId(String defaultSpaceId) {
            this.defaultSpaceId = defaultSpaceId;
            return this;
        }

        public UserOrganizationRoleEntityBuilder defaultSpaceUrl(String defaultSpaceUrl) {
            this.defaultSpaceUrl = defaultSpaceUrl;
            return this;
        }

        public UserOrganizationRoleEntityBuilder managedOrganizationsUrl(String managedOrganizationsUrl) {
            this.managedOrganizationsUrl = managedOrganizationsUrl;
            return this;
        }

        public UserOrganizationRoleEntityBuilder managedSpacesUrl(String managedSpacesUrl) {
            this.managedSpacesUrl = managedSpacesUrl;
            return this;
        }

        public UserOrganizationRoleEntityBuilder organizationsUrl(String organizationsUrl) {
            this.organizationsUrl = organizationsUrl;
            return this;
        }

        public UserOrganizationRoleEntityBuilder organizationRole(String organizationRole) {
            if (this.organizationRoles == null) {
                this.organizationRoles = new ArrayList();
            }
            this.organizationRoles.add(organizationRole);
            return this;
        }

        public UserOrganizationRoleEntityBuilder organizationRoles(Collection<? extends String> organizationRoles) {
            if (this.organizationRoles == null) {
                this.organizationRoles = new ArrayList();
            }
            this.organizationRoles.addAll(organizationRoles);
            return this;
        }

        public UserOrganizationRoleEntityBuilder spacesUrl(String spacesUrl) {
            this.spacesUrl = spacesUrl;
            return this;
        }

        public UserOrganizationRoleEntityBuilder username(String username) {
            this.username = username;
            return this;
        }

        public UserOrganizationRoleEntity build() {
            List<String> organizationRoles;
            switch (this.organizationRoles == null ? 0 : this.organizationRoles.size()) {
                case 0: {
                    organizationRoles = Collections.emptyList();
                    break;
                }
                case 1: {
                    organizationRoles = Collections.singletonList(this.organizationRoles.get(0));
                    break;
                }
                default: {
                    organizationRoles = Collections.unmodifiableList(new ArrayList<String>(this.organizationRoles));
                }
            }
            return new UserOrganizationRoleEntity(this.active, this.admin, this.auditedOrganizationsUrl, this.auditedSpacesUrl, this.billingManagedOrganizationsUrl, this.defaultSpaceId, this.defaultSpaceUrl, this.managedOrganizationsUrl, this.managedSpacesUrl, this.organizationsUrl, organizationRoles, this.spacesUrl, this.username);
        }

        public String toString() {
            return "UserOrganizationRoleEntity.UserOrganizationRoleEntityBuilder(active=" + this.active + ", admin=" + this.admin + ", auditedOrganizationsUrl=" + this.auditedOrganizationsUrl + ", auditedSpacesUrl=" + this.auditedSpacesUrl + ", billingManagedOrganizationsUrl=" + this.billingManagedOrganizationsUrl + ", defaultSpaceId=" + this.defaultSpaceId + ", defaultSpaceUrl=" + this.defaultSpaceUrl + ", managedOrganizationsUrl=" + this.managedOrganizationsUrl + ", managedSpacesUrl=" + this.managedSpacesUrl + ", organizationsUrl=" + this.organizationsUrl + ", organizationRoles=" + this.organizationRoles + ", spacesUrl=" + this.spacesUrl + ", username=" + this.username + ")";
        }
    }
}

