/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.privatedomains;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class CreatePrivateDomainRequest
implements Validatable {
    private final String name;
    private final String owningOrganizationId;

    CreatePrivateDomainRequest(String name, String owningOrganizationId) {
        this.name = name;
        this.owningOrganizationId = owningOrganizationId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.name == null) {
            builder.message("name must be specified");
        }
        if (this.owningOrganizationId == null) {
            builder.message("owning organization id must be specified");
        }
        return builder.build();
    }

    public static CreatePrivateDomainRequestBuilder builder() {
        return new CreatePrivateDomainRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreatePrivateDomainRequest)) {
            return false;
        }
        CreatePrivateDomainRequest other = (CreatePrivateDomainRequest)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$owningOrganizationId = this.getOwningOrganizationId();
        String other$owningOrganizationId = other.getOwningOrganizationId();
        return !(this$owningOrganizationId == null ? other$owningOrganizationId != null : !this$owningOrganizationId.equals(other$owningOrganizationId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $owningOrganizationId = this.getOwningOrganizationId();
        result = result * 59 + ($owningOrganizationId == null ? 43 : $owningOrganizationId.hashCode());
        return result;
    }

    public String toString() {
        return "CreatePrivateDomainRequest(name=" + this.getName() + ", owningOrganizationId=" + this.getOwningOrganizationId() + ")";
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="owning_organization_guid")
    public String getOwningOrganizationId() {
        return this.owningOrganizationId;
    }

    public static class CreatePrivateDomainRequestBuilder {
        private String name;
        private String owningOrganizationId;

        CreatePrivateDomainRequestBuilder() {
        }

        public CreatePrivateDomainRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CreatePrivateDomainRequestBuilder owningOrganizationId(String owningOrganizationId) {
            this.owningOrganizationId = owningOrganizationId;
            return this;
        }

        public CreatePrivateDomainRequest build() {
            return new CreatePrivateDomainRequest(this.name, this.owningOrganizationId);
        }

        public String toString() {
            return "CreatePrivateDomainRequest.CreatePrivateDomainRequestBuilder(name=" + this.name + ", owningOrganizationId=" + this.owningOrganizationId + ")";
        }
    }
}

