/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.privatedomains;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class DeletePrivateDomainRequest
implements Validatable {
    private final Boolean async;
    private final String privateDomainId;

    DeletePrivateDomainRequest(Boolean async, String privateDomainId) {
        this.async = async;
        this.privateDomainId = privateDomainId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.privateDomainId == null) {
            builder.message("private domain id must be specified");
        }
        return builder.build();
    }

    public static DeletePrivateDomainRequestBuilder builder() {
        return new DeletePrivateDomainRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeletePrivateDomainRequest)) {
            return false;
        }
        DeletePrivateDomainRequest other = (DeletePrivateDomainRequest)o;
        Boolean this$async = this.getAsync();
        Boolean other$async = other.getAsync();
        if (this$async == null ? other$async != null : !((Object)this$async).equals(other$async)) {
            return false;
        }
        String this$privateDomainId = this.getPrivateDomainId();
        String other$privateDomainId = other.getPrivateDomainId();
        return !(this$privateDomainId == null ? other$privateDomainId != null : !this$privateDomainId.equals(other$privateDomainId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $async = this.getAsync();
        result = result * 59 + ($async == null ? 43 : ((Object)$async).hashCode());
        String $privateDomainId = this.getPrivateDomainId();
        result = result * 59 + ($privateDomainId == null ? 43 : $privateDomainId.hashCode());
        return result;
    }

    public String toString() {
        return "DeletePrivateDomainRequest(async=" + this.getAsync() + ", privateDomainId=" + this.getPrivateDomainId() + ")";
    }

    @QueryParameter(value="async")
    public Boolean getAsync() {
        return this.async;
    }

    @JsonIgnore
    public String getPrivateDomainId() {
        return this.privateDomainId;
    }

    public static class DeletePrivateDomainRequestBuilder {
        private Boolean async;
        private String privateDomainId;

        DeletePrivateDomainRequestBuilder() {
        }

        public DeletePrivateDomainRequestBuilder async(Boolean async) {
            this.async = async;
            return this;
        }

        public DeletePrivateDomainRequestBuilder privateDomainId(String privateDomainId) {
            this.privateDomainId = privateDomainId;
            return this;
        }

        public DeletePrivateDomainRequest build() {
            return new DeletePrivateDomainRequest(this.async, this.privateDomainId);
        }

        public String toString() {
            return "DeletePrivateDomainRequest.DeletePrivateDomainRequestBuilder(async=" + this.async + ", privateDomainId=" + this.privateDomainId + ")";
        }
    }
}

