/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.privatedomains;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class GetPrivateDomainRequest
implements Validatable {
    private final String privateDomainId;

    GetPrivateDomainRequest(String privateDomainId) {
        this.privateDomainId = privateDomainId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.privateDomainId == null) {
            builder.message("private domain id must be specified");
        }
        return builder.build();
    }

    public static GetPrivateDomainRequestBuilder builder() {
        return new GetPrivateDomainRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetPrivateDomainRequest)) {
            return false;
        }
        GetPrivateDomainRequest other = (GetPrivateDomainRequest)o;
        String this$privateDomainId = this.getPrivateDomainId();
        String other$privateDomainId = other.getPrivateDomainId();
        return !(this$privateDomainId == null ? other$privateDomainId != null : !this$privateDomainId.equals(other$privateDomainId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $privateDomainId = this.getPrivateDomainId();
        result = result * 59 + ($privateDomainId == null ? 43 : $privateDomainId.hashCode());
        return result;
    }

    public String toString() {
        return "GetPrivateDomainRequest(privateDomainId=" + this.getPrivateDomainId() + ")";
    }

    @JsonIgnore
    public String getPrivateDomainId() {
        return this.privateDomainId;
    }

    public static class GetPrivateDomainRequestBuilder {
        private String privateDomainId;

        GetPrivateDomainRequestBuilder() {
        }

        public GetPrivateDomainRequestBuilder privateDomainId(String privateDomainId) {
            this.privateDomainId = privateDomainId;
            return this;
        }

        public GetPrivateDomainRequest build() {
            return new GetPrivateDomainRequest(this.privateDomainId);
        }

        public String toString() {
            return "GetPrivateDomainRequest.GetPrivateDomainRequestBuilder(privateDomainId=" + this.privateDomainId + ")";
        }
    }
}

