/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.privatedomains;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListPrivateDomainsRequest
extends PaginatedRequest
implements Validatable {
    private final List<String> names;

    ListPrivateDomainsRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> names) {
        super(orderDirection, page, resultsPerPage);
        this.names = names;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        return builder.build();
    }

    public static ListPrivateDomainsRequestBuilder builder() {
        return new ListPrivateDomainsRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListPrivateDomainsRequest)) {
            return false;
        }
        ListPrivateDomainsRequest other = (ListPrivateDomainsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$names = this.getNames();
        List<String> other$names = other.getNames();
        return !(this$names == null ? other$names != null : !((Object)this$names).equals(other$names));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListPrivateDomainsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $names = this.getNames();
        result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListPrivateDomainsRequest(super=" + super.toString() + ", names=" + this.getNames() + ")";
    }

    @InFilterParameter(value="name")
    public List<String> getNames() {
        return this.names;
    }

    public static class ListPrivateDomainsRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private ArrayList<String> names;

        ListPrivateDomainsRequestBuilder() {
        }

        public ListPrivateDomainsRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListPrivateDomainsRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListPrivateDomainsRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListPrivateDomainsRequestBuilder name(String name) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.add(name);
            return this;
        }

        public ListPrivateDomainsRequestBuilder names(Collection<? extends String> names) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.addAll(names);
            return this;
        }

        public ListPrivateDomainsRequest build() {
            List<String> names;
            switch (this.names == null ? 0 : this.names.size()) {
                case 0: {
                    names = Collections.emptyList();
                    break;
                }
                case 1: {
                    names = Collections.singletonList(this.names.get(0));
                    break;
                }
                default: {
                    names = Collections.unmodifiableList(new ArrayList<String>(this.names));
                }
            }
            return new ListPrivateDomainsRequest(this.orderDirection, this.page, this.resultsPerPage, names);
        }

        public String toString() {
            return "ListPrivateDomainsRequest.ListPrivateDomainsRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", names=" + this.names + ")";
        }
    }
}

