/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.privatedomains;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.v2.PaginatedResponse;
import org.cloudfoundry.client.v2.privatedomains.PrivateDomainResource;

public final class ListPrivateDomainsResponse
extends PaginatedResponse<PrivateDomainResource> {
    ListPrivateDomainsResponse(@JsonProperty(value="next_url") String nextUrl, @JsonProperty(value="prev_url") String previousUrl, @JsonProperty(value="resources") List<PrivateDomainResource> resources, @JsonProperty(value="total_pages") Integer totalPages, @JsonProperty(value="total_results") Integer totalResults) {
        super(nextUrl, previousUrl, resources, totalPages, totalResults);
    }

    public static ListPrivateDomainsResponseBuilder builder() {
        return new ListPrivateDomainsResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListPrivateDomainsResponse)) {
            return false;
        }
        ListPrivateDomainsResponse other = (ListPrivateDomainsResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListPrivateDomainsResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ListPrivateDomainsResponse(super=" + super.toString() + ")";
    }

    public static class ListPrivateDomainsResponseBuilder {
        private String nextUrl;
        private String previousUrl;
        private ArrayList<PrivateDomainResource> resources;
        private Integer totalPages;
        private Integer totalResults;

        ListPrivateDomainsResponseBuilder() {
        }

        public ListPrivateDomainsResponseBuilder nextUrl(String nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        public ListPrivateDomainsResponseBuilder previousUrl(String previousUrl) {
            this.previousUrl = previousUrl;
            return this;
        }

        public ListPrivateDomainsResponseBuilder resource(PrivateDomainResource resource) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
            return this;
        }

        public ListPrivateDomainsResponseBuilder resources(Collection<? extends PrivateDomainResource> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.addAll(resources);
            return this;
        }

        public ListPrivateDomainsResponseBuilder totalPages(Integer totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        public ListPrivateDomainsResponseBuilder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public ListPrivateDomainsResponse build() {
            List<PrivateDomainResource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
                case 0: {
                    resources = Collections.emptyList();
                    break;
                }
                case 1: {
                    resources = Collections.singletonList(this.resources.get(0));
                    break;
                }
                default: {
                    resources = Collections.unmodifiableList(new ArrayList<PrivateDomainResource>(this.resources));
                }
            }
            return new ListPrivateDomainsResponse(this.nextUrl, this.previousUrl, resources, this.totalPages, this.totalResults);
        }

        public String toString() {
            return "ListPrivateDomainsResponse.ListPrivateDomainsResponseBuilder(nextUrl=" + this.nextUrl + ", previousUrl=" + this.previousUrl + ", resources=" + this.resources + ", totalPages=" + this.totalPages + ", totalResults=" + this.totalResults + ")";
        }
    }
}

