/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.routemappings;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class CreateRouteMappingRequest
implements Validatable {
    private final String applicationId;
    private final Integer applicationPort;
    private final String routeId;

    CreateRouteMappingRequest(String applicationId, Integer applicationPort, String routeId) {
        this.applicationId = applicationId;
        this.applicationPort = applicationPort;
        this.routeId = routeId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        if (this.routeId == null) {
            builder.message("route id must be specified");
        }
        return builder.build();
    }

    public static CreateRouteMappingRequestBuilder builder() {
        return new CreateRouteMappingRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateRouteMappingRequest)) {
            return false;
        }
        CreateRouteMappingRequest other = (CreateRouteMappingRequest)o;
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        Integer this$applicationPort = this.getApplicationPort();
        Integer other$applicationPort = other.getApplicationPort();
        if (this$applicationPort == null ? other$applicationPort != null : !((Object)this$applicationPort).equals(other$applicationPort)) {
            return false;
        }
        String this$routeId = this.getRouteId();
        String other$routeId = other.getRouteId();
        return !(this$routeId == null ? other$routeId != null : !this$routeId.equals(other$routeId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        Integer $applicationPort = this.getApplicationPort();
        result = result * 59 + ($applicationPort == null ? 43 : ((Object)$applicationPort).hashCode());
        String $routeId = this.getRouteId();
        result = result * 59 + ($routeId == null ? 43 : $routeId.hashCode());
        return result;
    }

    public String toString() {
        return "CreateRouteMappingRequest(applicationId=" + this.getApplicationId() + ", applicationPort=" + this.getApplicationPort() + ", routeId=" + this.getRouteId() + ")";
    }

    @JsonProperty(value="app_guid")
    public String getApplicationId() {
        return this.applicationId;
    }

    @JsonProperty(value="app_port")
    public Integer getApplicationPort() {
        return this.applicationPort;
    }

    @JsonProperty(value="route_guid")
    public String getRouteId() {
        return this.routeId;
    }

    public static class CreateRouteMappingRequestBuilder {
        private String applicationId;
        private Integer applicationPort;
        private String routeId;

        CreateRouteMappingRequestBuilder() {
        }

        public CreateRouteMappingRequestBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public CreateRouteMappingRequestBuilder applicationPort(Integer applicationPort) {
            this.applicationPort = applicationPort;
            return this;
        }

        public CreateRouteMappingRequestBuilder routeId(String routeId) {
            this.routeId = routeId;
            return this;
        }

        public CreateRouteMappingRequest build() {
            return new CreateRouteMappingRequest(this.applicationId, this.applicationPort, this.routeId);
        }

        public String toString() {
            return "CreateRouteMappingRequest.CreateRouteMappingRequestBuilder(applicationId=" + this.applicationId + ", applicationPort=" + this.applicationPort + ", routeId=" + this.routeId + ")";
        }
    }
}

