/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.routemappings;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class DeleteRouteMappingRequest
implements Validatable {
    private final Boolean async;
    private final String routeMappingId;

    DeleteRouteMappingRequest(String routeMappingId, Boolean async) {
        this.routeMappingId = routeMappingId;
        this.async = async;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.routeMappingId == null) {
            builder.message("route mapping id must be specified");
        }
        return builder.build();
    }

    public static DeleteRouteMappingRequestBuilder builder() {
        return new DeleteRouteMappingRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteRouteMappingRequest)) {
            return false;
        }
        DeleteRouteMappingRequest other = (DeleteRouteMappingRequest)o;
        Boolean this$async = this.getAsync();
        Boolean other$async = other.getAsync();
        if (this$async == null ? other$async != null : !((Object)this$async).equals(other$async)) {
            return false;
        }
        String this$routeMappingId = this.getRouteMappingId();
        String other$routeMappingId = other.getRouteMappingId();
        return !(this$routeMappingId == null ? other$routeMappingId != null : !this$routeMappingId.equals(other$routeMappingId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $async = this.getAsync();
        result = result * 59 + ($async == null ? 43 : ((Object)$async).hashCode());
        String $routeMappingId = this.getRouteMappingId();
        result = result * 59 + ($routeMappingId == null ? 43 : $routeMappingId.hashCode());
        return result;
    }

    public String toString() {
        return "DeleteRouteMappingRequest(async=" + this.getAsync() + ", routeMappingId=" + this.getRouteMappingId() + ")";
    }

    @QueryParameter(value="async")
    public Boolean getAsync() {
        return this.async;
    }

    @JsonIgnore
    public String getRouteMappingId() {
        return this.routeMappingId;
    }

    public static class DeleteRouteMappingRequestBuilder {
        private String routeMappingId;
        private Boolean async;

        DeleteRouteMappingRequestBuilder() {
        }

        public DeleteRouteMappingRequestBuilder routeMappingId(String routeMappingId) {
            this.routeMappingId = routeMappingId;
            return this;
        }

        public DeleteRouteMappingRequestBuilder async(Boolean async) {
            this.async = async;
            return this;
        }

        public DeleteRouteMappingRequest build() {
            return new DeleteRouteMappingRequest(this.routeMappingId, this.async);
        }

        public String toString() {
            return "DeleteRouteMappingRequest.DeleteRouteMappingRequestBuilder(routeMappingId=" + this.routeMappingId + ", async=" + this.async + ")";
        }
    }
}

