/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.routemappings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public class ListRouteMappingsRequest
extends PaginatedRequest
implements Validatable {
    private final List<String> applicationIds;
    private final List<String> routeIds;

    ListRouteMappingsRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> applicationIds, List<String> routeIds) {
        super(orderDirection, page, resultsPerPage);
        this.applicationIds = applicationIds;
        this.routeIds = routeIds;
    }

    @Override
    public ValidationResult isValid() {
        return ValidationResult.builder().build();
    }

    public static ListRouteMappingsRequestBuilder builder() {
        return new ListRouteMappingsRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListRouteMappingsRequest)) {
            return false;
        }
        ListRouteMappingsRequest other = (ListRouteMappingsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$applicationIds = this.getApplicationIds();
        List<String> other$applicationIds = other.getApplicationIds();
        if (this$applicationIds == null ? other$applicationIds != null : !((Object)this$applicationIds).equals(other$applicationIds)) {
            return false;
        }
        List<String> this$routeIds = this.getRouteIds();
        List<String> other$routeIds = other.getRouteIds();
        return !(this$routeIds == null ? other$routeIds != null : !((Object)this$routeIds).equals(other$routeIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListRouteMappingsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $applicationIds = this.getApplicationIds();
        result = result * 59 + ($applicationIds == null ? 43 : ((Object)$applicationIds).hashCode());
        List<String> $routeIds = this.getRouteIds();
        result = result * 59 + ($routeIds == null ? 43 : ((Object)$routeIds).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListRouteMappingsRequest(super=" + super.toString() + ", applicationIds=" + this.getApplicationIds() + ", routeIds=" + this.getRouteIds() + ")";
    }

    @InFilterParameter(value="app_guid")
    public List<String> getApplicationIds() {
        return this.applicationIds;
    }

    @InFilterParameter(value="route_guid")
    public List<String> getRouteIds() {
        return this.routeIds;
    }

    public static class ListRouteMappingsRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private ArrayList<String> applicationIds;
        private ArrayList<String> routeIds;

        ListRouteMappingsRequestBuilder() {
        }

        public ListRouteMappingsRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListRouteMappingsRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListRouteMappingsRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListRouteMappingsRequestBuilder applicationId(String applicationId) {
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList();
            }
            this.applicationIds.add(applicationId);
            return this;
        }

        public ListRouteMappingsRequestBuilder applicationIds(Collection<? extends String> applicationIds) {
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList();
            }
            this.applicationIds.addAll(applicationIds);
            return this;
        }

        public ListRouteMappingsRequestBuilder routeId(String routeId) {
            if (this.routeIds == null) {
                this.routeIds = new ArrayList();
            }
            this.routeIds.add(routeId);
            return this;
        }

        public ListRouteMappingsRequestBuilder routeIds(Collection<? extends String> routeIds) {
            if (this.routeIds == null) {
                this.routeIds = new ArrayList();
            }
            this.routeIds.addAll(routeIds);
            return this;
        }

        public ListRouteMappingsRequest build() {
            List<String> routeIds;
            List<String> applicationIds;
            switch (this.applicationIds == null ? 0 : this.applicationIds.size()) {
                case 0: {
                    applicationIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    applicationIds = Collections.singletonList(this.applicationIds.get(0));
                    break;
                }
                default: {
                    applicationIds = Collections.unmodifiableList(new ArrayList<String>(this.applicationIds));
                }
            }
            switch (this.routeIds == null ? 0 : this.routeIds.size()) {
                case 0: {
                    routeIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    routeIds = Collections.singletonList(this.routeIds.get(0));
                    break;
                }
                default: {
                    routeIds = Collections.unmodifiableList(new ArrayList<String>(this.routeIds));
                }
            }
            return new ListRouteMappingsRequest(this.orderDirection, this.page, this.resultsPerPage, applicationIds, routeIds);
        }

        public String toString() {
            return "ListRouteMappingsRequest.ListRouteMappingsRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", applicationIds=" + this.applicationIds + ", routeIds=" + this.routeIds + ")";
        }
    }
}

