/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.routes;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class CreateRouteRequest
implements Validatable {
    private final String domainId;
    private final String generatePort;
    private final String host;
    private final String path;
    private final Integer port;
    private final String spaceId;

    CreateRouteRequest(String domainId, String generatePort, String host, String path, Integer port, String spaceId) {
        this.domainId = domainId;
        this.generatePort = generatePort;
        this.host = host;
        this.path = path;
        this.port = port;
        this.spaceId = spaceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.domainId == null) {
            builder.message("domain id must be specified");
        }
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    public static CreateRouteRequestBuilder builder() {
        return new CreateRouteRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateRouteRequest)) {
            return false;
        }
        CreateRouteRequest other = (CreateRouteRequest)o;
        String this$domainId = this.getDomainId();
        String other$domainId = other.getDomainId();
        if (this$domainId == null ? other$domainId != null : !this$domainId.equals(other$domainId)) {
            return false;
        }
        String this$generatePort = this.getGeneratePort();
        String other$generatePort = other.getGeneratePort();
        if (this$generatePort == null ? other$generatePort != null : !this$generatePort.equals(other$generatePort)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$spaceId = this.getSpaceId();
        String other$spaceId = other.getSpaceId();
        return !(this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $domainId = this.getDomainId();
        result = result * 59 + ($domainId == null ? 43 : $domainId.hashCode());
        String $generatePort = this.getGeneratePort();
        result = result * 59 + ($generatePort == null ? 43 : $generatePort.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $spaceId = this.getSpaceId();
        result = result * 59 + ($spaceId == null ? 43 : $spaceId.hashCode());
        return result;
    }

    public String toString() {
        return "CreateRouteRequest(domainId=" + this.getDomainId() + ", generatePort=" + this.getGeneratePort() + ", host=" + this.getHost() + ", path=" + this.getPath() + ", port=" + this.getPort() + ", spaceId=" + this.getSpaceId() + ")";
    }

    @JsonProperty(value="domain_guid")
    public String getDomainId() {
        return this.domainId;
    }

    @QueryParameter(value="generate_port")
    public String getGeneratePort() {
        return this.generatePort;
    }

    @JsonProperty(value="host")
    public String getHost() {
        return this.host;
    }

    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="port")
    public Integer getPort() {
        return this.port;
    }

    @JsonProperty(value="space_guid")
    public String getSpaceId() {
        return this.spaceId;
    }

    public static class CreateRouteRequestBuilder {
        private String domainId;
        private String generatePort;
        private String host;
        private String path;
        private Integer port;
        private String spaceId;

        CreateRouteRequestBuilder() {
        }

        public CreateRouteRequestBuilder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public CreateRouteRequestBuilder generatePort(String generatePort) {
            this.generatePort = generatePort;
            return this;
        }

        public CreateRouteRequestBuilder host(String host) {
            this.host = host;
            return this;
        }

        public CreateRouteRequestBuilder path(String path) {
            this.path = path;
            return this;
        }

        public CreateRouteRequestBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        public CreateRouteRequestBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public CreateRouteRequest build() {
            return new CreateRouteRequest(this.domainId, this.generatePort, this.host, this.path, this.port, this.spaceId);
        }

        public String toString() {
            return "CreateRouteRequest.CreateRouteRequestBuilder(domainId=" + this.domainId + ", generatePort=" + this.generatePort + ", host=" + this.host + ", path=" + this.path + ", port=" + this.port + ", spaceId=" + this.spaceId + ")";
        }
    }
}

