/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.routes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.IsFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListRouteApplicationsRequest
extends PaginatedRequest
implements Validatable {
    private final Boolean diego;
    private final List<String> names;
    private final List<String> organizationIds;
    private final String routeId;
    private final List<String> spaceIds;
    private final List<String> stackIds;

    ListRouteApplicationsRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, Boolean diego, List<String> names, List<String> organizationIds, String routeId, List<String> spaceIds, List<String> stackIds) {
        super(orderDirection, page, resultsPerPage);
        this.diego = diego;
        this.names = names;
        this.organizationIds = organizationIds;
        this.routeId = routeId;
        this.spaceIds = spaceIds;
        this.stackIds = stackIds;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.routeId == null) {
            builder.message("route id must be specified");
        }
        return builder.build();
    }

    public static ListRouteApplicationsRequestBuilder builder() {
        return new ListRouteApplicationsRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListRouteApplicationsRequest)) {
            return false;
        }
        ListRouteApplicationsRequest other = (ListRouteApplicationsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$diego = this.getDiego();
        Boolean other$diego = other.getDiego();
        if (this$diego == null ? other$diego != null : !((Object)this$diego).equals(other$diego)) {
            return false;
        }
        List<String> this$names = this.getNames();
        List<String> other$names = other.getNames();
        if (this$names == null ? other$names != null : !((Object)this$names).equals(other$names)) {
            return false;
        }
        List<String> this$organizationIds = this.getOrganizationIds();
        List<String> other$organizationIds = other.getOrganizationIds();
        if (this$organizationIds == null ? other$organizationIds != null : !((Object)this$organizationIds).equals(other$organizationIds)) {
            return false;
        }
        String this$routeId = this.getRouteId();
        String other$routeId = other.getRouteId();
        if (this$routeId == null ? other$routeId != null : !this$routeId.equals(other$routeId)) {
            return false;
        }
        List<String> this$spaceIds = this.getSpaceIds();
        List<String> other$spaceIds = other.getSpaceIds();
        if (this$spaceIds == null ? other$spaceIds != null : !((Object)this$spaceIds).equals(other$spaceIds)) {
            return false;
        }
        List<String> this$stackIds = this.getStackIds();
        List<String> other$stackIds = other.getStackIds();
        return !(this$stackIds == null ? other$stackIds != null : !((Object)this$stackIds).equals(other$stackIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListRouteApplicationsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Boolean $diego = this.getDiego();
        result = result * 59 + ($diego == null ? 43 : ((Object)$diego).hashCode());
        List<String> $names = this.getNames();
        result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
        List<String> $organizationIds = this.getOrganizationIds();
        result = result * 59 + ($organizationIds == null ? 43 : ((Object)$organizationIds).hashCode());
        String $routeId = this.getRouteId();
        result = result * 59 + ($routeId == null ? 43 : $routeId.hashCode());
        List<String> $spaceIds = this.getSpaceIds();
        result = result * 59 + ($spaceIds == null ? 43 : ((Object)$spaceIds).hashCode());
        List<String> $stackIds = this.getStackIds();
        result = result * 59 + ($stackIds == null ? 43 : ((Object)$stackIds).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListRouteApplicationsRequest(super=" + super.toString() + ", diego=" + this.getDiego() + ", names=" + this.getNames() + ", organizationIds=" + this.getOrganizationIds() + ", routeId=" + this.getRouteId() + ", spaceIds=" + this.getSpaceIds() + ", stackIds=" + this.getStackIds() + ")";
    }

    @IsFilterParameter(value="diego")
    public Boolean getDiego() {
        return this.diego;
    }

    @InFilterParameter(value="name")
    public List<String> getNames() {
        return this.names;
    }

    @InFilterParameter(value="organization_guid")
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    @JsonIgnore
    public String getRouteId() {
        return this.routeId;
    }

    @InFilterParameter(value="space_guid")
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }

    @InFilterParameter(value="stack_guid")
    public List<String> getStackIds() {
        return this.stackIds;
    }

    public static class ListRouteApplicationsRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private Boolean diego;
        private ArrayList<String> names;
        private ArrayList<String> organizationIds;
        private String routeId;
        private ArrayList<String> spaceIds;
        private ArrayList<String> stackIds;

        ListRouteApplicationsRequestBuilder() {
        }

        public ListRouteApplicationsRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListRouteApplicationsRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListRouteApplicationsRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListRouteApplicationsRequestBuilder diego(Boolean diego) {
            this.diego = diego;
            return this;
        }

        public ListRouteApplicationsRequestBuilder name(String name) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.add(name);
            return this;
        }

        public ListRouteApplicationsRequestBuilder names(Collection<? extends String> names) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.addAll(names);
            return this;
        }

        public ListRouteApplicationsRequestBuilder organizationId(String organizationId) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList();
            }
            this.organizationIds.add(organizationId);
            return this;
        }

        public ListRouteApplicationsRequestBuilder organizationIds(Collection<? extends String> organizationIds) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList();
            }
            this.organizationIds.addAll(organizationIds);
            return this;
        }

        public ListRouteApplicationsRequestBuilder routeId(String routeId) {
            this.routeId = routeId;
            return this;
        }

        public ListRouteApplicationsRequestBuilder spaceId(String spaceId) {
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList();
            }
            this.spaceIds.add(spaceId);
            return this;
        }

        public ListRouteApplicationsRequestBuilder spaceIds(Collection<? extends String> spaceIds) {
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList();
            }
            this.spaceIds.addAll(spaceIds);
            return this;
        }

        public ListRouteApplicationsRequestBuilder stackId(String stackId) {
            if (this.stackIds == null) {
                this.stackIds = new ArrayList();
            }
            this.stackIds.add(stackId);
            return this;
        }

        public ListRouteApplicationsRequestBuilder stackIds(Collection<? extends String> stackIds) {
            if (this.stackIds == null) {
                this.stackIds = new ArrayList();
            }
            this.stackIds.addAll(stackIds);
            return this;
        }

        public ListRouteApplicationsRequest build() {
            List<String> stackIds;
            List<String> spaceIds;
            List<String> organizationIds;
            List<String> names;
            switch (this.names == null ? 0 : this.names.size()) {
                case 0: {
                    names = Collections.emptyList();
                    break;
                }
                case 1: {
                    names = Collections.singletonList(this.names.get(0));
                    break;
                }
                default: {
                    names = Collections.unmodifiableList(new ArrayList<String>(this.names));
                }
            }
            switch (this.organizationIds == null ? 0 : this.organizationIds.size()) {
                case 0: {
                    organizationIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    organizationIds = Collections.singletonList(this.organizationIds.get(0));
                    break;
                }
                default: {
                    organizationIds = Collections.unmodifiableList(new ArrayList<String>(this.organizationIds));
                }
            }
            switch (this.spaceIds == null ? 0 : this.spaceIds.size()) {
                case 0: {
                    spaceIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    spaceIds = Collections.singletonList(this.spaceIds.get(0));
                    break;
                }
                default: {
                    spaceIds = Collections.unmodifiableList(new ArrayList<String>(this.spaceIds));
                }
            }
            switch (this.stackIds == null ? 0 : this.stackIds.size()) {
                case 0: {
                    stackIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    stackIds = Collections.singletonList(this.stackIds.get(0));
                    break;
                }
                default: {
                    stackIds = Collections.unmodifiableList(new ArrayList<String>(this.stackIds));
                }
            }
            return new ListRouteApplicationsRequest(this.orderDirection, this.page, this.resultsPerPage, this.diego, names, organizationIds, this.routeId, spaceIds, stackIds);
        }

        public String toString() {
            return "ListRouteApplicationsRequest.ListRouteApplicationsRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", diego=" + this.diego + ", names=" + this.names + ", organizationIds=" + this.organizationIds + ", routeId=" + this.routeId + ", spaceIds=" + this.spaceIds + ", stackIds=" + this.stackIds + ")";
        }
    }
}

