/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.routes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListRoutesRequest
extends PaginatedRequest
implements Validatable {
    private final List<String> domainIds;
    private final List<String> hosts;
    private final String organizationId;
    private final List<String> paths;

    ListRoutesRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> domainIds, List<String> hosts, String organizationId, List<String> paths) {
        super(orderDirection, page, resultsPerPage);
        this.domainIds = domainIds;
        this.hosts = hosts;
        this.organizationId = organizationId;
        this.paths = paths;
    }

    @Override
    public ValidationResult isValid() {
        return ValidationResult.builder().build();
    }

    public static ListRoutesRequestBuilder builder() {
        return new ListRoutesRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListRoutesRequest)) {
            return false;
        }
        ListRoutesRequest other = (ListRoutesRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$domainIds = this.getDomainIds();
        List<String> other$domainIds = other.getDomainIds();
        if (this$domainIds == null ? other$domainIds != null : !((Object)this$domainIds).equals(other$domainIds)) {
            return false;
        }
        List<String> this$hosts = this.getHosts();
        List<String> other$hosts = other.getHosts();
        if (this$hosts == null ? other$hosts != null : !((Object)this$hosts).equals(other$hosts)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        List<String> this$paths = this.getPaths();
        List<String> other$paths = other.getPaths();
        return !(this$paths == null ? other$paths != null : !((Object)this$paths).equals(other$paths));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListRoutesRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $domainIds = this.getDomainIds();
        result = result * 59 + ($domainIds == null ? 43 : ((Object)$domainIds).hashCode());
        List<String> $hosts = this.getHosts();
        result = result * 59 + ($hosts == null ? 43 : ((Object)$hosts).hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        List<String> $paths = this.getPaths();
        result = result * 59 + ($paths == null ? 43 : ((Object)$paths).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListRoutesRequest(super=" + super.toString() + ", domainIds=" + this.getDomainIds() + ", hosts=" + this.getHosts() + ", organizationId=" + this.getOrganizationId() + ", paths=" + this.getPaths() + ")";
    }

    @InFilterParameter(value="domain_guid")
    public List<String> getDomainIds() {
        return this.domainIds;
    }

    @InFilterParameter(value="host")
    public List<String> getHosts() {
        return this.hosts;
    }

    @InFilterParameter(value="organization_guid")
    public String getOrganizationId() {
        return this.organizationId;
    }

    @InFilterParameter(value="path")
    public List<String> getPaths() {
        return this.paths;
    }

    public static class ListRoutesRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private ArrayList<String> domainIds;
        private ArrayList<String> hosts;
        private String organizationId;
        private ArrayList<String> paths;

        ListRoutesRequestBuilder() {
        }

        public ListRoutesRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListRoutesRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListRoutesRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListRoutesRequestBuilder domainId(String domainId) {
            if (this.domainIds == null) {
                this.domainIds = new ArrayList();
            }
            this.domainIds.add(domainId);
            return this;
        }

        public ListRoutesRequestBuilder domainIds(Collection<? extends String> domainIds) {
            if (this.domainIds == null) {
                this.domainIds = new ArrayList();
            }
            this.domainIds.addAll(domainIds);
            return this;
        }

        public ListRoutesRequestBuilder host(String host) {
            if (this.hosts == null) {
                this.hosts = new ArrayList();
            }
            this.hosts.add(host);
            return this;
        }

        public ListRoutesRequestBuilder hosts(Collection<? extends String> hosts) {
            if (this.hosts == null) {
                this.hosts = new ArrayList();
            }
            this.hosts.addAll(hosts);
            return this;
        }

        public ListRoutesRequestBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public ListRoutesRequestBuilder path(String path) {
            if (this.paths == null) {
                this.paths = new ArrayList();
            }
            this.paths.add(path);
            return this;
        }

        public ListRoutesRequestBuilder paths(Collection<? extends String> paths) {
            if (this.paths == null) {
                this.paths = new ArrayList();
            }
            this.paths.addAll(paths);
            return this;
        }

        public ListRoutesRequest build() {
            List<String> paths;
            List<String> hosts;
            List<String> domainIds;
            switch (this.domainIds == null ? 0 : this.domainIds.size()) {
                case 0: {
                    domainIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    domainIds = Collections.singletonList(this.domainIds.get(0));
                    break;
                }
                default: {
                    domainIds = Collections.unmodifiableList(new ArrayList<String>(this.domainIds));
                }
            }
            switch (this.hosts == null ? 0 : this.hosts.size()) {
                case 0: {
                    hosts = Collections.emptyList();
                    break;
                }
                case 1: {
                    hosts = Collections.singletonList(this.hosts.get(0));
                    break;
                }
                default: {
                    hosts = Collections.unmodifiableList(new ArrayList<String>(this.hosts));
                }
            }
            switch (this.paths == null ? 0 : this.paths.size()) {
                case 0: {
                    paths = Collections.emptyList();
                    break;
                }
                case 1: {
                    paths = Collections.singletonList(this.paths.get(0));
                    break;
                }
                default: {
                    paths = Collections.unmodifiableList(new ArrayList<String>(this.paths));
                }
            }
            return new ListRoutesRequest(this.orderDirection, this.page, this.resultsPerPage, domainIds, hosts, this.organizationId, paths);
        }

        public String toString() {
            return "ListRoutesRequest.ListRoutesRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", domainIds=" + this.domainIds + ", hosts=" + this.hosts + ", organizationId=" + this.organizationId + ", paths=" + this.paths + ")";
        }
    }
}

